/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.drone.area;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.api.registry.PNCRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public abstract class AreaType {
    public static final Codec<AreaType> CODEC = PNCRegistries.AREA_TYPE_SERIALIZER_REGISTRY.byNameCodec().dispatch(AreaType::getSerializer, AreaTypeSerializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, AreaType> STREAM_CODEC = ByteBufCodecs.registry(PNCRegistries.AREA_TYPE_SERIALIZER_KEY).dispatch(AreaType::getSerializer, AreaTypeSerializer::streamCodec);
    private final String translationKey;
    private final String name;

    public AreaType(String name) {
        this.name = name;
        this.translationKey = String.format("pneumaticcraft.gui.progWidget.area.type.%s.name", name);
    }

    public abstract AreaTypeSerializer<? extends AreaType> getSerializer();

    public abstract AreaType copy();

    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public abstract void addArea(Consumer<BlockPos> var1, BlockPos var2, BlockPos var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public void convertFromLegacy(EnumOldAreaType oldType, int typeInfo) {
    }

    public boolean isDeterministic() {
        return true;
    }

    public void addUIWidgets(List<AreaTypeWidget> widgets) {
    }

    public static enum AreaAxis implements ITranslatableEnum,
    StringRepresentable
    {
        X("x"),
        Y("y"),
        Z("z");

        private final String name;

        private AreaAxis(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.area.type.axis." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

