/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.drone.area;

import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import net.minecraft.network.chat.Component;

public abstract class AreaTypeWidget {
    private final String translationKey;

    public AreaTypeWidget(String translationKey) {
        this.translationKey = translationKey;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public abstract Component getDisplayName();

    public static class EnumSelectorField<E extends ITranslatableEnum>
    extends AreaTypeWidget {
        public final Class<E> enumClass;
        public final Supplier<E> readAction;
        public final Consumer<E> writeAction;

        public EnumSelectorField(String translationKey, Class<E> enumClass, Supplier<E> readAction, Consumer<E> writeAction) {
            super(translationKey);
            this.enumClass = enumClass;
            this.readAction = readAction;
            this.writeAction = writeAction;
        }

        @Override
        public Component getDisplayName() {
            return Component.translatable((String)((ITranslatableEnum)this.readAction.get()).getTranslationKey());
        }
    }

    public static class IntegerField
    extends AreaTypeWidget {
        public final IntSupplier readAction;
        public final IntConsumer writeAction;

        public IntegerField(String translationKey, IntSupplier readAction, IntConsumer writeAction) {
            super(translationKey);
            this.readAction = readAction;
            this.writeAction = writeAction;
        }

        @Override
        public Component getDisplayName() {
            return Component.literal((String)Integer.toString(this.readAction.getAsInt()));
        }
    }
}

