/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.pneumatic_armor.hacking;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractPersistentEntityHack<T extends Entity>
implements IHackableEntity<T> {
    private final Component info;
    private final Component postInfo;

    protected AbstractPersistentEntityHack(StockHackTypes hack) {
        this(hack.getPreKey(), hack.getPostKey());
    }

    protected AbstractPersistentEntityHack(String infoKey, String postInfoKey) {
        this.info = Component.translatable((String)infoKey);
        this.postInfo = Component.translatable((String)postInfoKey);
    }

    @Override
    public boolean canHack(Entity entity, Player player) {
        return IHackableEntity.super.canHack(entity, player) && !this.alreadyHacked(entity);
    }

    private boolean alreadyHacked(T entity) {
        ICommonArmorRegistry reg = PneumaticRegistry.getInstance().getCommonArmorRegistry();
        return reg.getCurrentEntityHacks((Entity)entity).stream().anyMatch(hack -> hack.getHackableClass().isAssignableFrom(entity.getClass()));
    }

    @Override
    public void addHackInfo(T entity, List<Component> curInfo, Player player) {
        curInfo.add(this.info);
    }

    @Override
    public void addPostHackInfo(T entity, List<Component> curInfo, Player player) {
        curInfo.add(this.postInfo);
    }

    @Override
    public int getHackTime(T entity, Player player) {
        return 60;
    }

    @Override
    public void onHackFinished(T entity, Player player) {
        PneumaticRegistry.getInstance().getMiscHelpers().getHackingForEntity((Entity)entity, true).ifPresent(hacking -> hacking.addHackable(this));
    }

    @Override
    public boolean afterHackTick(T entity) {
        return true;
    }

    public static <T extends Entity> boolean hasPersistentHack(T entity, Class<? extends AbstractPersistentEntityHack<T>> cls) {
        ICommonArmorRegistry reg = PneumaticRegistry.getInstance().getCommonArmorRegistry();
        return reg.getCurrentEntityHacks(entity).stream().anyMatch(hack -> cls.isAssignableFrom(hack.getClass()));
    }

    public static enum StockHackTypes {
        DISARM("disarm", "disarmed"),
        STOP_TELEPORT("stopTeleport", "stoppedTeleport"),
        NEUTRALIZE("neutralize", "neutralized");

        private final String preHack;
        private final String postHack;

        private StockHackTypes(String preHack, String postHack) {
            this.preHack = preHack;
            this.postHack = postHack;
        }

        String getPreKey() {
            return "pneumaticcraft.armor.hacking.result." + this.preHack;
        }

        String getPostKey() {
            return "pneumaticcraft.armor.hacking.finished." + this.postHack;
        }
    }
}

