/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.hopper.LiquidHopperBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.LiquidHopperMenu;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class LiquidHopperScreen
extends AbstractPneumaticCraftContainerScreen<LiquidHopperMenu, LiquidHopperBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[2];

    public LiquidHopperScreen(LiquidHopperMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 116, this.topPos + 15, ((LiquidHopperBlockEntity)this.te).getTank()));
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.hopperStatus", new Object[0]), new ItemStack((ItemLike)ModBlocks.LIQUID_HOPPER.get()), -22016, false);
        WidgetAnimatedStat optionStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode", new Object[0]), new ItemStack((ItemLike)Blocks.LEVER), -13312, false);
        optionStat.setMinimumExpandedDimensions(50, 43);
        WidgetButtonExtended button = new WidgetButtonExtended(20, 20, 20, 20, (Component)Component.empty()).withTag("empty");
        button.setRenderStacks(new ItemStack((ItemLike)Items.BUCKET));
        button.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidHopper.mode.empty", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[0] = button;
        button = new WidgetButtonExtended(45, 20, 20, 20, (Component)Component.empty()).withTag("leave");
        button.setRenderStacks(new ItemStack((ItemLike)Items.WATER_BUCKET));
        button.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidHopper.mode.leaveLiquid", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[1] = button;
    }

    @Override
    protected boolean isUpgradeAvailable(PNCUpgrade upgrade) {
        return upgrade != ModUpgrades.DISPENSER.get() || (Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get() != false;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -1);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.statusStat.setText(this.getStatus());
        this.modeButtons[0].active = ((LiquidHopperBlockEntity)this.te).doesLeaveMaterial();
        this.modeButtons[1].active = !((LiquidHopperBlockEntity)this.te).doesLeaveMaterial();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LIQUID_HOPPER;
    }

    private List<Component> getStatus() {
        ArrayList<Component> textList = new ArrayList<Component>();
        int itemsPer = ((LiquidHopperBlockEntity)this.te).getMaxItems();
        if (itemsPer > 1) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.hopperStatus.liquidTransferPerTick", itemsPer * 100));
        } else {
            int transferInterval = ((LiquidHopperBlockEntity)this.te).getItemTransferInterval();
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.hopperStatus.liquidTransferPerSecond", transferInterval == 0 ? "2000" : PneumaticCraftUtils.roundNumberTo(2000.0f / (float)transferInterval, 1)));
        }
        return textList;
    }
}

