/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.inventory.PressureChamberInterfaceMenu;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PressureChamberInterfaceScreen
extends AbstractPneumaticCraftContainerScreen<PressureChamberInterfaceMenu, PressureChamberInterfaceBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private WidgetButtonExtended exportAnyButton;
    private WidgetLabel exportTypeLabel;
    private boolean hasEnoughPressure = true;

    public PressureChamberInterfaceScreen(PressureChamberInterfaceMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamberInterface.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()), -22016, false);
        this.exportAnyButton = (WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(this.leftPos + 100, this.topPos + 32, 60, 20, (Component)Component.empty()).withTag("export_mode"));
        this.exportTypeLabel = (WidgetLabel)this.addRenderableWidget((GuiEventListener)new WidgetLabel(this.leftPos + 100, this.topPos + 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamberInterface.exportLabel", new Object[0])));
        this.setupExportButtonVisibility();
    }

    private void setupExportButtonVisibility() {
        boolean exporting = ((PressureChamberInterfaceBlockEntity)this.te).interfaceMode == PressureChamberInterfaceBlockEntity.InterfaceDirection.EXPORT;
        this.exportAnyButton.setVisible(exporting);
        this.exportAnyButton.visible = exporting;
        this.exportTypeLabel.visible = exporting;
        if (exporting) {
            String textKey = "pneumaticcraft.gui.pressureChamberInterface.export." + (((PressureChamberInterfaceBlockEntity)this.te).exportAny ? "any" : "valid");
            this.exportAnyButton.setMessage((Component)PneumaticCraftUtils.xlate(textKey, new Object[0]));
            this.exportAnyButton.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate(textKey + ".tooltip", new Object[0])));
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        int inputShift = (int)((1.0f - Mth.cos((float)(((PressureChamberInterfaceBlockEntity)this.te).inputProgress / 125.663704f))) * 11.0f);
        int outputShift = (int)((1.0f - Mth.cos((float)(((PressureChamberInterfaceBlockEntity)this.te).outputProgress / 125.663704f))) * 11.0f);
        graphics.fill(63 + inputShift, 30, 87 + inputShift, 32, -10853633);
        graphics.fill(63 + outputShift, 54, 87 + outputShift, 56, -22528);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_PRESSURE_CHAMBER_INTERFACE;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.setupExportButtonVisibility();
        if (((PressureChamberInterfaceBlockEntity)this.te).interfaceMode != PressureChamberInterfaceBlockEntity.InterfaceDirection.NONE) {
            this.statusStat.setText((Component)PneumaticCraftUtils.xlate(((PressureChamberInterfaceBlockEntity)this.te).interfaceMode.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.BLACK));
        } else {
            this.statusStat.setText(Collections.emptyList());
        }
        if (this.hasEnoughPressure && !((PressureChamberInterfaceBlockEntity)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = false;
            this.problemTab.openStat();
        } else if (((PressureChamberInterfaceBlockEntity)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = true;
        }
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((PressureChamberInterfaceBlockEntity)this.te).interfaceMode == PressureChamberInterfaceBlockEntity.InterfaceDirection.NONE) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.pressure_chamber_interface.not_formed", new Object[0]));
        } else if (!((PressureChamberInterfaceBlockEntity)this.te).hasEnoughPressure()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.pressure_chamber_interface.not_enough_pressure", new Object[0]));
        }
    }
}

