/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.compressor.ThermalCompressorBlockEntity;
import me.desht.pneumaticcraft.common.inventory.ThermalCompressorMenu;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ThermalCompressorScreen
extends AbstractPneumaticCraftContainerScreen<ThermalCompressorMenu, ThermalCompressorBlockEntity> {
    private final WidgetTemperatureSided[] tempWidgets = new WidgetTemperatureSided[4];

    public ThermalCompressorScreen(ThermalCompressorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        for (Direction d : DirectionUtil.HORIZONTALS) {
            WidgetTemperatureSided widgetTemperatureSided = (WidgetTemperatureSided)((Object)new WidgetTemperatureSided(d).setDrawText(false));
            this.tempWidgets[d.get2DDataValue()] = widgetTemperatureSided;
            this.addRenderableWidget((GuiEventListener)widgetTemperatureSided);
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_THERMAL_COMPRESSOR;
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        return new PointXY(xStart + (int)((double)this.imageWidth * 0.82), yStart + this.imageHeight / 4 + 4);
    }

    private int getTemperatureDifferential(Direction side) {
        IHeatExchangerLogic l1 = ((ThermalCompressorBlockEntity)this.te).getHeatExchanger(side);
        IHeatExchangerLogic l2 = ((ThermalCompressorBlockEntity)this.te).getHeatExchanger(side.getOpposite());
        return l1 != null && l2 != null ? Math.abs(l1.getTemperatureAsInt() - l2.getTemperatureAsInt()) : 0;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        double prod = ((ThermalCompressorBlockEntity)this.te).airProduced(Direction.NORTH) + ((ThermalCompressorBlockEntity)this.te).airProduced(Direction.EAST);
        if (prod > 0.0 && ((ThermalCompressorBlockEntity)this.te).getRedstoneController().shouldRun()) {
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.producingAir", PneumaticCraftUtils.roundNumberTo(prod, 1)).withStyle(ChatFormatting.BLACK));
        }
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (this.getTemperatureDifferential(Direction.NORTH) < 10 && this.getTemperatureDifferential(Direction.EAST) < 10) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.thermal_compressor.no_temp_diff", new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        int dns = this.getTemperatureDifferential(Direction.NORTH);
        int dew = this.getTemperatureDifferential(Direction.EAST);
        if (dns < 20 && dew >= 10 && dew < 20 || dew < 20 && dns >= 10 && dns < 20) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.thermal_compressor.poor_temp_diff", new Object[0]));
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Direction d : DirectionUtil.HORIZONTALS) {
            int t = Objects.requireNonNull(((ThermalCompressorBlockEntity)this.te).getHeatExchanger(d)).getTemperatureAsInt();
            this.tempWidgets[d.get2DDataValue()].setTemperature(t);
            min = Math.min(min, t);
            max = Math.max(max, t);
        }
        int rounding = this.getRounding(max - min);
        TemperatureRange range = TemperatureRange.of(Math.max(0, WidgetTemperature.roundDownK(min - 1, rounding)), Math.min(2273, WidgetTemperature.roundUpK(max + 1, rounding)));
        int interval = WidgetTemperature.calcInterval(range.getMax() - range.getMin());
        for (WidgetTemperatureSided temp : this.tempWidgets) {
            temp.setTotalRange(range);
            temp.setTickInterval(interval);
        }
    }

    private int getRounding(int range) {
        if (range < 100) {
            return 10;
        }
        if (range < 250) {
            return 25;
        }
        if (range < 500) {
            return 50;
        }
        return 100;
    }

    static int getWidgetX(Direction side) {
        return switch (side) {
            case Direction.SOUTH -> 56;
            case Direction.NORTH -> 66;
            case Direction.WEST -> 89;
            case Direction.EAST -> 99;
            default -> throw new IllegalArgumentException("invalid side " + String.valueOf(side));
        };
    }

    private class WidgetTemperatureSided
    extends WidgetTemperature {
        private final Direction side;

        WidgetTemperatureSided(Direction side) {
            super(ThermalCompressorScreen.this.leftPos + ThermalCompressorScreen.getWidgetX(side), ThermalCompressorScreen.this.topPos + 20, TemperatureRange.of(0, 2000), 273, 200);
            this.side = side;
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            String s = this.side.toString().substring(0, 1).toUpperCase();
            GuiUtils.drawScaledText(graphics, ThermalCompressorScreen.this.font, (Component)Component.literal((String)s), this.getX() + 8, this.getY() - 4, 0x404040, 0.5f, false);
        }
    }
}

