/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.remote.IRemoteWidget;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.PastebinScreen;
import me.desht.pneumaticcraft.client.gui.remote.AbstractRemoteScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteClientRegistry;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.RemoteMenu;
import me.desht.pneumaticcraft.common.item.RemoteItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateRemoteLayout;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.remote.RemoteWidgetButton;
import me.desht.pneumaticcraft.common.remote.RemoteWidgetCheckbox;
import me.desht.pneumaticcraft.common.remote.RemoteWidgetDropdown;
import me.desht.pneumaticcraft.common.remote.RemoteWidgetLabel;
import me.desht.pneumaticcraft.common.remote.SavedRemoteLayout;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.legacyconv.ConversionType;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RemoteEditorScreen
extends AbstractRemoteScreen {
    private static final List<? extends IRemoteWidget> TRAY_WIDGETS = List.of((Record)RemoteWidgetCheckbox.TRAY.get(), (Record)RemoteWidgetLabel.TRAY.get(), (Record)RemoteWidgetButton.TRAY.get(), (Record)RemoteWidgetDropdown.TRAY.get());
    private static final int PROGRAMMING_AREA_WIDTH = 183;
    private static final Rect2i PROGRAMMING_AREA = new Rect2i(3, 18, 177, 181);
    private static final Rect2i TRAY_AREA = new Rect2i(195, 18, 80, 78);
    private InventorySearcherScreen invSearchGui;
    private PastebinScreen pastebinGui;
    private IRemoteWidget draggingRemoteWidget;
    private AbstractWidget draggingMCWidget;
    private AbstractWidget configuringMCWidget;

    public RemoteEditorScreen(RemoteMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageWidth = 283;
        this.imageHeight = 202;
    }

    @Override
    public void init() {
        super.init();
        if (this.pastebinGui != null && this.pastebinGui.getOutput() != null) {
            this.addWidgetsFromLayout(SavedRemoteLayout.fromJson((HolderLookup.Provider)this.registryAccess(), this.pastebinGui.getOutput()));
        } else if (this.invSearchGui != null && this.invSearchGui.getSearchStack().getItem() == ModItems.REMOTE.get()) {
            if (RemoteItem.hasSameSecuritySettings(this.remoteItem, this.invSearchGui.getSearchStack())) {
                this.addWidgetsFromLayout(SavedRemoteLayout.fromItem(this.invSearchGui.getSearchStack()));
            } else {
                ClientUtils.getClientPlayer().displayClientMessage((Component)Component.literal((String)"pneumaticcraft.gui.remote.differentSecuritySettings"), false);
            }
        } else if (this.widgetMap.isEmpty()) {
            this.addWidgetsFromLayout(SavedRemoteLayout.fromItem(this.remoteItem));
        } else {
            LinkedHashMap newMap = new LinkedHashMap();
            this.widgetMap.values().forEach(remoteWidget -> {
                Object newMCWidget = RemoteClientRegistry.INSTANCE.createMinecraftWidget(remoteWidget, this);
                newMap.put(newMCWidget, remoteWidget);
                this.addRenderableWidget((GuiEventListener)newMCWidget);
            });
            this.widgetMap.clear();
            this.widgetMap.putAll(newMap);
        }
        WidgetButtonExtended importBtn = new WidgetButtonExtended(this.leftPos - 24, this.topPos, 20, 20, (Component)Component.empty(), b -> this.openImportScreen()).setRenderStacks(new ItemStack((ItemLike)ModItems.REMOTE.get()));
        importBtn.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.importRemoteButton", new Object[0])));
        this.addRenderableWidget((GuiEventListener)importBtn);
        WidgetButtonExtended pastebinBtn = new WidgetButtonExtended(this.leftPos - 24, this.topPos + 22, 20, 20, (Component)Component.empty(), b -> this.openPastebinScreen()).setRenderedIcon(Textures.GUI_PASTEBIN_ICON_LOCATION);
        pastebinBtn.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.pastebinButton", new Object[0])));
        this.addRenderableWidget((GuiEventListener)pastebinBtn);
        WidgetCheckBox snapCheck = new WidgetCheckBox(this.leftPos + 194, this.topPos + 105, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.snapToGrid", new Object[0]), b -> ConfigHelper.setGuiRemoteGridSnap(b.checked));
        snapCheck.checked = (Boolean)ConfigHelper.client().general.guiRemoteGridSnap.get();
        this.addRenderableWidget((GuiEventListener)snapCheck);
        this.addRenderableWidget((GuiEventListener)new WidgetLabel(this.leftPos + 234, this.topPos + 7, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.widgetTray", new Object[0]).withStyle(ChatFormatting.DARK_BLUE)).setAlignment(WidgetLabel.Alignment.CENTRE));
    }

    private void addWidgetsFromLayout(SavedRemoteLayout layout) {
        this.widgetMap.clear();
        RemoteEditorScreen.buildMinecraftWidgetList(layout.getWidgets(), this, false).forEach(this::addRemoteWidget);
        for (IRemoteWidget iRemoteWidget : TRAY_WIDGETS) {
            this.addRemoteWidget((AbstractWidget)RemoteClientRegistry.INSTANCE.createMinecraftWidget(iRemoteWidget, this), iRemoteWidget);
        }
    }

    private void openImportScreen() {
        ClientUtils.openContainerGui(ModMenuTypes.INVENTORY_SEARCHER.get(), (Component)Component.translatable((String)"pneumaticcraft.gui.amadron.addTrade.invSearch"));
        if (this.minecraft.screen instanceof InventorySearcherScreen) {
            this.invSearchGui = (InventorySearcherScreen)this.minecraft.screen;
            this.invSearchGui.setStackPredicate(s -> s.getItem() == ModItems.REMOTE.get());
        }
    }

    private void openPastebinScreen() {
        JsonElement json = this.makeNewLayout().toJson((HolderLookup.Provider)this.registryAccess());
        this.pastebinGui = new PastebinScreen((Screen)this, json, ConversionType.ACTION_WIDGET);
        this.minecraft.setScreen((Screen)this.pastebinGui);
    }

    private SavedRemoteLayout makeNewLayout() {
        List list = (List)Util.make(new ArrayList(), l -> this.widgetMap.forEach((mcWidget, remoteWidget) -> {
            if (this.isInProgrammingArea((AbstractWidget)mcWidget)) {
                l.add(remoteWidget);
            }
        }));
        return new SavedRemoteLayout(list);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_REMOTE_EDITOR;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        graphics.blit(this.getGuiTexture(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 320, 256);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(-50, 0);
    }

    private boolean isInTrayArea(AbstractWidget widget) {
        return TRAY_AREA.contains(widget.getX() - this.getGuiLeft(), widget.getY() - this.getGuiTop());
    }

    private boolean isInProgrammingArea(AbstractWidget widget) {
        return PROGRAMMING_AREA.contains(widget.getX() - this.getGuiLeft(), widget.getY() - this.getGuiTop());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 0: {
                for (Map.Entry entry : this.widgetMap.entrySet()) {
                    AbstractWidget mcWidget = (AbstractWidget)entry.getKey();
                    boolean trayWidget = this.isInTrayArea(mcWidget);
                    if (!mcWidget.isHovered() || !this.isInProgrammingArea(mcWidget) && !trayWidget) continue;
                    IRemoteWidget remoteWidget = (IRemoteWidget)entry.getValue();
                    AbstractWidget mcDrag = trayWidget ? RemoteClientRegistry.INSTANCE.createMinecraftWidget(remoteWidget, this) : mcWidget;
                    this.startDrag(remoteWidget.copy(), mcDrag, trayWidget);
                    return true;
                }
                break;
            }
            case 1: {
                for (Map.Entry entry : this.widgetMap.entrySet()) {
                    IRemoteWidget remoteWidget;
                    Screen screen;
                    AbstractWidget mcWidget = (AbstractWidget)entry.getKey();
                    if (!mcWidget.isHovered() || !this.isInProgrammingArea(mcWidget) || (screen = RemoteClientRegistry.INSTANCE.createConfigurationScreen(remoteWidget = (IRemoteWidget)entry.getValue(), this)) == null) continue;
                    this.configuringMCWidget = mcWidget;
                    this.minecraft.setScreen(screen);
                    return true;
                }
                break;
            }
            case 2: {
                for (Map.Entry entry : this.widgetMap.entrySet()) {
                    AbstractWidget mcWidget = (AbstractWidget)entry.getKey();
                    if (!mcWidget.isHovered() || !this.isInProgrammingArea(mcWidget)) continue;
                    IRemoteWidget remoteWidget = (IRemoteWidget)entry.getValue();
                    Object newMCWidget = RemoteClientRegistry.INSTANCE.createMinecraftWidget(remoteWidget, this);
                    this.startDrag(remoteWidget.copy(), (AbstractWidget)newMCWidget, true);
                    return true;
                }
                break;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void startDrag(IRemoteWidget remoteWidget, AbstractWidget mcWidget, boolean copying) {
        this.draggingRemoteWidget = remoteWidget;
        this.draggingMCWidget = mcWidget;
        if (copying) {
            this.addRenderableWidget((GuiEventListener)this.draggingMCWidget);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.draggingRemoteWidget != null && this.draggingMCWidget != null) {
            if (!this.isInProgrammingArea(this.draggingMCWidget)) {
                this.removeWidget((GuiEventListener)this.draggingMCWidget);
                this.widgetMap.remove(this.draggingMCWidget);
            } else {
                this.widgetMap.put(this.draggingMCWidget, this.draggingRemoteWidget.copyToPos(this.draggingMCWidget.getX() - this.getGuiLeft(), this.draggingMCWidget.getY() - this.getGuiTop()));
            }
            this.draggingRemoteWidget = null;
            this.draggingMCWidget = null;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.draggingMCWidget != null) {
            int x1 = (int)mouseX;
            int y1 = (int)mouseY;
            if (((Boolean)ConfigHelper.client().general.guiRemoteGridSnap.get()).booleanValue()) {
                x1 = x1 / 4 * 4;
                y1 = y1 / 4 * 4;
            }
            this.draggingMCWidget.setPosition(x1, y1);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public void onClose() {
        ItemStack stack = ClientUtils.getClientPlayer().getItemInHand(((RemoteMenu)this.menu).getHand());
        if (stack.getItem() == ModItems.REMOTE.get()) {
            SavedRemoteLayout layout = this.makeNewLayout();
            RemoteItem.saveToItem(stack, layout);
            NetworkHandler.sendToServer(new PacketUpdateRemoteLayout(layout, ((RemoteMenu)this.menu).getHand()));
        }
        super.onClose();
    }

    public void updateWidgetFromConfigScreen(IRemoteWidget newWidget) {
        IRemoteWidget current;
        if (this.configuringMCWidget != null && (current = (IRemoteWidget)this.widgetMap.get(this.configuringMCWidget)) != null && !current.equals(newWidget)) {
            this.widgetMap.put(this.configuringMCWidget, newWidget);
            this.configuringMCWidget = null;
            this.rebuildWidgets();
        }
    }
}

