/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class CamoModel
implements IDynamicBakedModel {
    private final BakedModel originalModel;

    public CamoModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, RenderType renderType) {
        if (state == null || !(state.getBlock() instanceof AbstractCamouflageBlock)) {
            return this.originalModel.getQuads(state, side, rand, modelData, renderType);
        }
        BlockState camoState = (BlockState)modelData.get(AbstractCamouflageBlock.CAMO_STATE);
        if (renderType == null) {
            renderType = RenderType.solid();
        }
        if (camoState == null && renderType == RenderType.solid()) {
            return this.originalModel.getQuads(state, side, rand, modelData, renderType);
        }
        if (camoState != null && this.getRenderTypes(camoState, rand, modelData).contains(renderType)) {
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(camoState);
            return model.getQuads(camoState, side, rand, modelData, renderType);
        }
        return Collections.emptyList();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState camoState = (BlockState)data.get(AbstractCamouflageBlock.CAMO_STATE);
        return super.getRenderTypes(camoState == null ? state : camoState, rand, data);
    }

    public boolean useAmbientOcclusion() {
        return this.originalModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.originalModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return this.originalModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.originalModel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.originalModel.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.originalModel.getOverrides();
    }

    private record FakeBlockAccess(BlockGetter getter) implements BlockGetter
    {
        @Nullable
        public BlockEntity getBlockEntity(BlockPos pos) {
            return this.getter.getBlockEntity(pos);
        }

        @Nonnull
        public BlockState getBlockState(@Nonnull BlockPos pos) {
            BlockEntity te;
            BlockState state = this.getter.getBlockState(pos);
            if (state.getBlock() instanceof AbstractCamouflageBlock && (te = this.getter.getBlockEntity(pos)) instanceof CamouflageableBlockEntity) {
                state = ((CamouflageableBlockEntity)te).getCamouflage();
            }
            return state == null ? Blocks.AIR.defaultBlockState() : state;
        }

        @Nonnull
        public FluidState getFluidState(@Nonnull BlockPos blockPos) {
            return this.getter.getFluidState(blockPos);
        }

        public int getHeight() {
            return this.getter.getHeight();
        }

        public int getMinBuildHeight() {
            return this.getter.getMinBuildHeight();
        }
    }
}

