/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.item.IFluidRendered;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.neoforged.neoforge.fluids.IFluidTank;
import org.jetbrains.annotations.Nullable;

public class FluidItemModel
extends BakedModelWrapper<BakedModel> {
    private final ItemOverrides overrideList = new FluidOverridesList(this);
    private List<TankRenderInfo> tanksToRender = Collections.emptyList();

    private FluidItemModel(BakedModel bakedBaseModel) {
        super(bakedBaseModel);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@javax.annotation.Nullable BlockState state, @javax.annotation.Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> res = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData, renderType));
        for (TankRenderInfo info : this.tanksToRender) {
            ImmutableList vecs;
            IFluidTank tank = info.getTank();
            if (tank.getFluid().isEmpty()) continue;
            Fluid fluid = tank.getFluid().getFluid();
            IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid);
            ResourceLocation texture = renderProps.getStillTexture(tank.getFluid());
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
            int color = renderProps.getTintColor(tank.getFluid());
            float[] cols = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            AABB bounds = this.getRenderBounds(tank, info.getBounds());
            float bx1 = (float)bounds.minX;
            float bx2 = (float)bounds.maxX;
            float by1 = (float)bounds.minY;
            float by2 = (float)bounds.maxY;
            float bz1 = (float)bounds.minZ;
            float bz2 = (float)bounds.maxZ;
            if (info.shouldRender(Direction.DOWN)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.maxX, bounds.minY, bounds.minZ), (Object)new Vec3(bounds.maxX, bounds.minY, bounds.maxZ), (Object)new Vec3(bounds.minX, bounds.minY, bounds.maxZ), (Object)new Vec3(bounds.minX, bounds.minY, bounds.minZ));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.DOWN, bx1, bx2, bz1, bz2));
            }
            if (info.shouldRender(Direction.UP)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.minX, bounds.maxY, bounds.minZ), (Object)new Vec3(bounds.minX, bounds.maxY, bounds.maxZ), (Object)new Vec3(bounds.maxX, bounds.maxY, bounds.maxZ), (Object)new Vec3(bounds.maxX, bounds.maxY, bounds.minZ));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.UP, bx1, bx2, bz1, bz2));
            }
            if (info.shouldRender(Direction.NORTH)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.maxX, bounds.maxY, bounds.minZ), (Object)new Vec3(bounds.maxX, bounds.minY, bounds.minZ), (Object)new Vec3(bounds.minX, bounds.minY, bounds.minZ), (Object)new Vec3(bounds.minX, bounds.maxY, bounds.minZ));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.NORTH, bx1, bx2, by1, by2));
            }
            if (info.shouldRender(Direction.SOUTH)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.minX, bounds.maxY, bounds.maxZ), (Object)new Vec3(bounds.minX, bounds.minY, bounds.maxZ), (Object)new Vec3(bounds.maxX, bounds.minY, bounds.maxZ), (Object)new Vec3(bounds.maxX, bounds.maxY, bounds.maxZ));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.SOUTH, bx1, bx2, by1, by2));
            }
            if (info.shouldRender(Direction.WEST)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.minX, bounds.maxY, bounds.minZ), (Object)new Vec3(bounds.minX, bounds.minY, bounds.minZ), (Object)new Vec3(bounds.minX, bounds.minY, bounds.maxZ), (Object)new Vec3(bounds.minX, bounds.maxY, bounds.maxZ));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.WEST, bz1, bz2, by1, by2));
            }
            if (!info.shouldRender(Direction.EAST)) continue;
            vecs = ImmutableList.of((Object)new Vec3(bounds.maxX, bounds.maxY, bounds.maxZ), (Object)new Vec3(bounds.maxX, bounds.minY, bounds.maxZ), (Object)new Vec3(bounds.maxX, bounds.minY, bounds.minZ), (Object)new Vec3(bounds.maxX, bounds.maxY, bounds.minZ));
            res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.EAST, bz1, bz2, by1, by2));
        }
        return res;
    }

    private AABB getRenderBounds(IFluidTank tank, AABB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.maxY - tankBounds.minY;
        double y1 = tankBounds.minY;
        double y2 = tankBounds.minY + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getFluidType().isLighterThanAir()) {
            double yOff = tankBounds.maxY - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AABB(tankBounds.minX, y1, tankBounds.minZ, tankBounds.maxX, y2, tankBounds.maxZ);
    }

    private BakedQuad createQuad(List<Vec3> vecs, float[] cols, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
        QuadBakingVertexConsumer quadBaker = new QuadBakingVertexConsumer();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)face.getNormal());
        this.putVertex(quadBaker, normal, vecs.get((int)0).x, vecs.get((int)0).y, vecs.get((int)0).z, u1, v1, sprite, cols, face);
        this.putVertex(quadBaker, normal, vecs.get((int)1).x, vecs.get((int)1).y, vecs.get((int)1).z, u1, v2, sprite, cols, face);
        this.putVertex(quadBaker, normal, vecs.get((int)2).x, vecs.get((int)2).y, vecs.get((int)2).z, u2, v2, sprite, cols, face);
        this.putVertex(quadBaker, normal, vecs.get((int)3).x, vecs.get((int)3).y, vecs.get((int)3).z, u2, v1, sprite, cols, face);
        return quadBaker.bakeQuad();
    }

    private void putVertex(QuadBakingVertexConsumer quadBaker, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float[] cols, Direction face) {
        quadBaker.addVertex((float)x, (float)y, (float)z);
        quadBaker.setNormal((float)normal.x, (float)normal.y, (float)normal.z);
        quadBaker.setColor(cols[1], cols[2], cols[3], cols[0]);
        quadBaker.setUv(sprite.getU(u), sprite.getV(v));
        quadBaker.setSprite(sprite);
        quadBaker.setDirection(face);
    }

    public ItemOverrides getOverrides() {
        return this.overrideList;
    }

    public BakedModel applyTransform(ItemDisplayContext cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        super.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
        return this;
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return List.of(this);
    }

    private static class FluidOverridesList
    extends ItemOverrides {
        private final FluidItemModel modelIn;

        FluidOverridesList(FluidItemModel modelIn) {
            this.modelIn = modelIn;
        }

        @javax.annotation.Nullable
        public BakedModel resolve(BakedModel original, ItemStack stack, @javax.annotation.Nullable ClientLevel world, @javax.annotation.Nullable LivingEntity entity, int seed) {
            Item item = stack.getItem();
            if (item instanceof IFluidRendered) {
                IFluidRendered r = (IFluidRendered)item;
                this.modelIn.tanksToRender = r.getFluidItemRenderer().getTanksToRender(stack);
            }
            return this.modelIn;
        }
    }

    public static enum Loader implements IGeometryLoader<Geometry>
    {
        INSTANCE;


        public Geometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.getAsJsonObject((JsonObject)modelContents, (String)"base_model"), BlockModel.class);
            return new Geometry(baseModel);
        }
    }

    public record Geometry(BlockModel baseModel) implements IUnbakedGeometry<Geometry>
    {
        public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides) {
            return new FluidItemModel(this.baseModel.bake(baker, Objects.requireNonNull(this.baseModel.parent), spriteGetter, modelTransform, true));
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.baseModel.resolveParents(modelGetter);
        }
    }
}

