/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.api.client.assembly_machine.IAssemblyRenderOverriding;
import me.desht.pneumaticcraft.client.ClientRegistryImpl;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractAssemblyRenderer;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyIOUnitBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;

public class AssemblyIOUnitRenderer
extends AbstractAssemblyRenderer<AssemblyIOUnitBlockEntity> {
    private final ModelPart baseTurn;
    private final ModelPart baseTurn2;
    private final ModelPart armBase;
    private final ModelPart armMiddle;
    private final ModelPart clawBase;
    private final ModelPart clawAxle;
    private final ModelPart clawTurn;
    private final ModelPart claw1;
    private final ModelPart claw2;
    private static final float ITEM_SCALE = 0.5f;
    private static final String BASETURN = "baseTurn";
    private static final String BASETURN2 = "baseTurn2";
    private static final String ARMBASE = "armBase";
    private static final String ARMMIDDLE = "armMiddle";
    private static final String CLAWBASE = "clawBase";
    private static final String CLAWAXLE = "clawAxle";
    private static final String CLAWTURN = "clawTurn";
    private static final String CLAW1 = "claw1";
    private static final String CLAW2 = "claw2";

    public AssemblyIOUnitRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.ASSEMBLY_IO_UNIT);
        this.baseTurn = root.getChild(BASETURN);
        this.baseTurn2 = root.getChild(BASETURN2);
        this.armBase = root.getChild(ARMBASE);
        this.armMiddle = root.getChild(ARMMIDDLE);
        this.clawBase = root.getChild(CLAWBASE);
        this.clawAxle = root.getChild(CLAWAXLE);
        this.clawTurn = root.getChild(CLAWTURN);
        this.claw1 = root.getChild(CLAW1);
        this.claw2 = root.getChild(CLAW2);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BASETURN, CubeListBuilder.create().texOffs(0, 0).addBox("baseTurn_0", -1.0f, 0.0f, -1.0f, 9, 1, 9, 0, 0).mirror(), PartPose.offset((float)-3.5f, (float)22.0f, (float)-3.5f));
        partdefinition.addOrReplaceChild(BASETURN2, CubeListBuilder.create().texOffs(0, 0).addBox("baseTurn2_0", -2.0f, -0.5f, 0.5f, 2, 6, 3, new CubeDeformation(0.2f), 0, 30).addBox("baseTurn2_1", -2.0f, 3.75f, -2.0f, 2, 2, 8, 0, 10).addBox("baseTurn2_2", 4.0f, -0.5f, 0.5f, 2, 6, 3, new CubeDeformation(0.2f), 10, 30).addBox("baseTurn2_3", 4.0f, 3.75f, -2.0f, 2, 2, 8, 0, 20).mirror(), PartPose.offset((float)-2.0f, (float)17.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild(ARMBASE, CubeListBuilder.create().texOffs(0, 0).addBox("armBase_0", 2.0f, 0.0f, 1.0f, 2, 2, 5, new CubeDeformation(0.3f), 0, 49).addBox("armBase_1", 1.5f, -0.5f, -0.5f, 3, 3, 3, 0, 43).addBox("armBase_2", 1.5f, -0.5f, 5.5f, 3, 3, 3, 12, 43).addBox("armBase_3", -1.5f, 0.0f, 0.0f, 9, 2, 2, 0, 39).mirror(), PartPose.offset((float)-3.0f, (float)17.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild(ARMMIDDLE, CubeListBuilder.create().texOffs(0, 0).addBox("armMiddle_0", 0.0f, 2.0f, 0.0f, 2, 13, 2, 20, 10).addBox("armMiddle_1", 0.0f, 0.0f, 0.0f, 2, 2, 2, new CubeDeformation(0.3f), 12, 24).addBox("armMiddle_2", 0.0f, 15.0f, 0.0f, 2, 2, 2, new CubeDeformation(0.3f), 0, 24).addBox("armMiddle_3", -0.5f, 15.0f, 0.0f, 3, 2, 2, 14, 52).mirror(), PartPose.offset((float)-4.0f, (float)2.0f, (float)5.0f));
        partdefinition.addOrReplaceChild(CLAWBASE, CubeListBuilder.create().texOffs(0, 0).addBox("clawBase_0", -1.0f, -1.0f, 0.0f, 4, 4, 5, 46, 0).mirror(), PartPose.offset((float)-1.0f, (float)2.0f, (float)4.5f));
        partdefinition.addOrReplaceChild(CLAWAXLE, CubeListBuilder.create().texOffs(0, 0).addBox("clawAxle_0", -0.5f, -0.5f, 0.0f, 2, 2, 1, 58, 9).mirror(), PartPose.offset((float)-0.5f, (float)2.5f, (float)4.0f));
        partdefinition.addOrReplaceChild(CLAWTURN, CubeListBuilder.create().texOffs(0, 0).addBox("clawTurn_0", 0.0f, -0.5f, 0.0f, 4, 3, 1, new CubeDeformation(0.1f), 54, 12).mirror(), PartPose.offset((float)-2.0f, (float)2.0f, (float)3.0f));
        partdefinition.addOrReplaceChild(CLAW1, CubeListBuilder.create().texOffs(0, 0).addBox("claw1_0", -0.1f, -0.5f, -1.35f, 1, 3, 2, new CubeDeformation(-0.1f), 52, 21).addBox("claw1_1", 0.25f, 0.0f, -1.35f, 1, 2, 2, 58, 21).mirror(), PartPose.offset((float)0.0f, (float)2.0f, (float)2.25f));
        partdefinition.addOrReplaceChild(CLAW2, CubeListBuilder.create().texOffs(0, 0).addBox("claw2_0", 0.1f, -0.5f, -1.35f, 1, 3, 2, new CubeDeformation(-0.1f), 52, 16).addBox("claw2_1", -0.25f, 0.0f, -1.35f, 1, 2, 2, 58, 16).mirror(), PartPose.offset((float)-1.0f, (float)2.0f, (float)2.25f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    void renderModel(AssemblyIOUnitBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IAssemblyRenderOverriding renderOverride;
        float[] angles = new float[5];
        for (int i = 0; i < 5; ++i) {
            angles[i] = te.oldAngles[i] + (te.angles[i] - te.oldAngles[i]) * partialTicks;
        }
        ItemStack heldStack = te.getItemHandler(null).getStackInSlot(0);
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTexture(te)));
        Pair<IAssemblyRenderOverriding, Float> clawTranslation = this.getClawTranslation(Mth.lerp((float)partialTicks, (float)te.oldClawProgress, (float)te.clawProgress), heldStack);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(angles[0]));
        this.baseTurn.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.baseTurn2.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0f, 1.125f, 0.0f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(angles[1]));
        matrixStackIn.translate(0.0f, -1.125f, 0.0f);
        this.armBase.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0f, 1.125f, 0.375f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(angles[2]));
        matrixStackIn.translate(0.0f, -1.125f, -0.375f);
        this.armMiddle.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0f, 0.1875f, 0.375f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(angles[3]));
        matrixStackIn.translate(0.0f, -0.1875f, -0.375f);
        this.clawBase.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0f, 0.1875f, 0.0f);
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(angles[4]));
        matrixStackIn.translate(0.0f, -0.1875f, 0.0f);
        this.clawAxle.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.clawTurn.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.pushPose();
        matrixStackIn.translate(((Float)clawTranslation.getRight()).floatValue(), 0.0f, 0.0f);
        this.claw1.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(-2.0f * ((Float)clawTranslation.getRight()).floatValue(), 0.0f, 0.0f);
        this.claw2.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.popPose();
        if (!heldStack.isEmpty() && ((renderOverride = (IAssemblyRenderOverriding)clawTranslation.getLeft()) == null || renderOverride.applyRenderChangeIOUnit(matrixStackIn, heldStack))) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
            double yOffset = heldStack.getItem() instanceof BlockItem ? 0.09375 : 0.03125;
            matrixStackIn.translate(0.0, yOffset, -0.1875);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-90.0f));
            matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel bakedModel = itemRenderer.getModel(heldStack, te.getLevel(), null, 0);
            itemRenderer.render(heldStack, ItemDisplayContext.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedModel);
        }
    }

    private Pair<IAssemblyRenderOverriding, Float> getClawTranslation(float clawProgress, ItemStack heldStack) {
        IAssemblyRenderOverriding renderOverride = ClientRegistryImpl.getInstance().getAssemblyRenderOverride((ItemLike)heldStack.getItem());
        float clawTrans = !heldStack.isEmpty() ? (renderOverride != null ? renderOverride.getIOUnitClawShift(heldStack) : (heldStack.getItem() instanceof BlockItem ? 0.09375f - clawProgress * 0.1f / 16.0f : 0.09375f - clawProgress * 1.4f / 16.0f)) : 0.09375f - clawProgress * 1.5f / 16.0f;
        return Pair.of((Object)renderOverride, (Object)Float.valueOf(clawTrans));
    }

    private ResourceLocation getTexture(AssemblyIOUnitBlockEntity te) {
        return te != null && te.isImportUnit() ? Textures.MODEL_ASSEMBLY_IO_IMPORT : Textures.MODEL_ASSEMBLY_IO_EXPORT;
    }
}

