/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberValveBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class PressureChamberRenderer
implements BlockEntityRenderer<PressureChamberValveBlockEntity> {
    public PressureChamberRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(PressureChamberValveBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.multiBlockSize == 0 || !te.hasGlass) {
            return;
        }
        List<ItemStack> stacks = te.renderedItems;
        if (!stacks.isEmpty()) {
            double x = (double)(te.multiBlockX - te.getBlockPos().getX()) + (double)te.multiBlockSize / 2.0;
            double y = (double)(te.multiBlockY - te.getBlockPos().getY()) + 1.1;
            double z = (double)(te.multiBlockZ - te.getBlockPos().getZ()) + (double)te.multiBlockSize / 2.0;
            int light = ClientUtils.getLightAt(new BlockPos(te.multiBlockX + te.multiBlockSize / 2, te.multiBlockY + 1, te.multiBlockZ + te.multiBlockSize / 2));
            matrixStackIn.pushPose();
            matrixStackIn.translate(x, y, z);
            float circleRadius = stacks.size() == 1 ? 0.0f : 0.33f * (float)(te.multiBlockSize - 2);
            float degreesPerStack = 360.0f / (float)stacks.size();
            double ticks = (float)te.nonNullLevel().getGameTime() + partialTicks;
            float yBob = Mth.sin((float)((float)ticks / 10.0f % 360.0f)) * 0.01f;
            float yRot = (float)(ticks / 2.0) % 360.0f;
            for (int i = 0; i < stacks.size(); ++i) {
                matrixStackIn.pushPose();
                matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)i * degreesPerStack));
                matrixStackIn.translate((double)circleRadius, (double)yBob + 0.2, 0.0);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(yRot));
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                BakedModel bakedModel = itemRenderer.getModel(stacks.get(i), te.getLevel(), null, 0);
                itemRenderer.render(stacks.get(i), ItemDisplayContext.FIXED, true, matrixStackIn, bufferIn, light, combinedOverlayIn, bakedModel);
                matrixStackIn.popPose();
            }
            matrixStackIn.popPose();
        }
    }

    public AABB getRenderBoundingBox(PressureChamberValveBlockEntity blockEntity) {
        return blockEntity.getChamberAABB();
    }
}

