/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pressure_gauge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PressureGaugeRenderer3D {
    private static final float RADIUS = 19.0f;
    private static final float PI_F = (float)Math.PI;
    private static final float START_ANGLE = 4.1887903f;
    private static final float STOP_ANGLE = -1.0471976f;
    private static final int CIRCLE_POINTS = 180;
    private static final int GAUGE_POINTS = 150;
    private static final float[][] GAUGE_SURROUND = new float[181][2];

    public static void drawPressureGauge(PoseStack matrixStack, MultiBufferSource buffer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer3D.drawPressureGauge(matrixStack, buffer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, -16777216);
    }

    public static void drawPressureGauge(PoseStack poseStack, MultiBufferSource buffer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, int fgColor) {
        Matrix3f normal = poseStack.last().normal();
        RenderUtils.renderWithType(poseStack, buffer, ModRenderTypes.TRIANGLE_FAN, (posMat, builder) -> PressureGaugeRenderer3D.drawGaugeBackground(posMat, builder, minPressure, maxPressure, dangerPressure, minWorkingPressure, xPos, yPos));
        RenderUtils.renderWithType(poseStack, buffer, (RenderType)RenderType.LINE_STRIP, (posMat, builder) -> PressureGaugeRenderer3D.drawGaugeSurround(poseStack, builder, xPos, yPos, fgColor));
        int currentScale = (int)maxPressure;
        ArrayList<PressureGaugeRenderer2D.TextScaler> textScalers = new ArrayList<PressureGaugeRenderer2D.TextScaler>();
        RenderUtils.renderWithType(poseStack, buffer, (RenderType)RenderType.LINES, (posMat, builder) -> PressureGaugeRenderer3D.drawScale(poseStack, builder, minPressure, maxPressure, xPos, yPos, currentScale, textScalers));
        RenderUtils.renderWithType(poseStack, buffer, (RenderType)RenderType.LINE_STRIP, (posMat, builder) -> {
            float angleIndicator = 150 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
            angleIndicator = -angleIndicator / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            PressureGaugeRenderer3D.drawNeedle(poseStack, builder, xPos, yPos, angleIndicator, fgColor);
        });
        PressureGaugeRenderer3D.drawText(poseStack, buffer, xPos, yPos, fgColor, textScalers);
    }

    private static void drawGaugeBackground(Matrix4f posMat, VertexConsumer builder, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, int xPos, int yPos) {
        float[] color = PressureGaugeRenderer2D.RED;
        builder.addVertex(posMat, (float)xPos, (float)yPos, 0.0f).setColor(0.5f, 0.5f, 0.1f, 1.0f);
        int explodeBoundary = 150 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
        int workingBoundary = 150 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 150; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? PressureGaugeRenderer2D.YELLOW : PressureGaugeRenderer2D.GREEN;
                builder.addVertex(posMat, (float)xPos, (float)yPos, 0.0f).setColor(color[0], color[1], color[2], color[3]);
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? PressureGaugeRenderer2D.GREEN : PressureGaugeRenderer2D.YELLOW;
                builder.addVertex(posMat, (float)xPos, (float)yPos, 0.0f).setColor(color[0], color[1], color[2], color[3]);
                --i;
                changedColorYellow = true;
            }
            float angle = (float)(-i) / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            builder.addVertex(posMat, Mth.cos((float)angle) * 19.0f + (float)xPos, Mth.sin((float)angle) * 19.0f + (float)yPos, 0.0f).setColor(color[0], color[1], color[2], color[3]);
        }
    }

    private static void drawGaugeSurround(PoseStack poseStack, VertexConsumer builder, int xPos, int yPos, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        for (int i = 0; i < 180; ++i) {
            RenderUtils.normalLine(builder, poseStack, GAUGE_SURROUND[i][0] + (float)xPos, GAUGE_SURROUND[i][1] + (float)yPos, 0.0f, GAUGE_SURROUND[i + 1][0] + (float)xPos, GAUGE_SURROUND[i + 1][1] + (float)yPos, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
        }
    }

    private static void drawScale(PoseStack poseStack, VertexConsumer builder, float minPressure, float maxPressure, int xPos, int yPos, int currentScale, List<PressureGaugeRenderer2D.TextScaler> textScalers) {
        for (int i = 0; i <= 150; ++i) {
            float angle = (float)(-i) / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            if (i != 150 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 150.0f)) continue;
            float x = Mth.cos((float)angle);
            float y = Mth.sin((float)angle);
            textScalers.add(new PressureGaugeRenderer2D.TextScaler(currentScale, (int)(x * 19.0f * 1.3f), (int)(y * 19.0f * 1.3f)));
            --currentScale;
            float r1 = maxPressure > 12.0f && textScalers.size() % 5 == 1 ? 0.8f : 0.92f;
            float r2 = maxPressure > 12.0f && textScalers.size() % 5 == 1 ? 1.15f : 1.08f;
            float x1 = x * 19.0f * r1 + (float)xPos;
            float y1 = y * 19.0f * r1 + (float)yPos;
            float x2 = x * 19.0f * r2 + (float)xPos;
            float y2 = y * 19.0f * r2 + (float)yPos;
            RenderUtils.normalLine(builder, poseStack, x1, y1, 0.0f, x2, y2, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, false);
        }
    }

    private static void drawNeedle(PoseStack poseStack, VertexConsumer builder, int xPos, int yPos, float angle, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        float x1 = Mth.cos((float)(angle + 2.7960174f)) * 19.0f * 0.3f + (float)xPos;
        float y1 = Mth.sin((float)(angle + 2.7960174f)) * 19.0f * 0.3f + (float)yPos;
        float x2 = Mth.cos((float)(angle + 3.487168f)) * 19.0f * 0.3f + (float)xPos;
        float y2 = Mth.sin((float)(angle + 3.487168f)) * 19.0f * 0.3f + (float)yPos;
        float x3 = Mth.cos((float)angle) * 19.0f * 0.8f + (float)xPos;
        float y3 = Mth.sin((float)angle) * 19.0f * 0.8f + (float)yPos;
        RenderUtils.normalLine(builder, poseStack, x1, y1, 0.0f, x2, y2, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
        RenderUtils.normalLine(builder, poseStack, x2, y2, 0.0f, x3, y3, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
        RenderUtils.normalLine(builder, poseStack, x3, y3, 0.0f, x1, y1, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
        RenderUtils.normalLine(builder, poseStack, x1, y1, 0.0f, x2, y2, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
    }

    private static void drawText(PoseStack matrixStack, MultiBufferSource buffer, int xPos, int yPos, int fgColor, List<PressureGaugeRenderer2D.TextScaler> textScalers) {
        for (int i = 0; i < textScalers.size(); ++i) {
            if (textScalers.size() > 14 && i % 5 != 0) continue;
            PressureGaugeRenderer2D.TextScaler scaler = textScalers.get(i);
            matrixStack.pushPose();
            matrixStack.translate((double)(xPos + scaler.x()) - 1.5, (double)(yPos + scaler.y()) - 1.5, 0.0);
            matrixStack.scale(0.5f, 0.5f, 1.0f);
            RenderUtils.renderString3d((Component)Component.literal((String)Integer.toString(scaler.pressure())), 0.0f, 0.0f, fgColor, matrixStack, buffer, false, false);
            matrixStack.popPose();
        }
    }

    static {
        for (int i = 0; i <= 180; ++i) {
            float angle = (float)i / 180.0f * 2.0f * (float)Math.PI;
            PressureGaugeRenderer3D.GAUGE_SURROUND[i][0] = Mth.cos((float)angle) * 19.0f;
            PressureGaugeRenderer3D.GAUGE_SURROUND[i][1] = Mth.sin((float)angle) * 19.0f;
        }
    }
}

