/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.KeroseneLampBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KeroseneLampBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_NS = VoxelShapeUtils.or(Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), Block.box((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)11.5, (double)0.0, (double)7.0, (double)12.5, (double)10.0, (double)9.0), Block.box((double)11.0, (double)0.0, (double)7.0, (double)12.0, (double)1.0, (double)9.0), Block.box((double)11.0, (double)9.0, (double)7.0, (double)12.0, (double)10.0, (double)9.0), Block.box((double)4.0, (double)0.0, (double)7.0, (double)5.0, (double)1.0, (double)9.0), Block.box((double)4.0, (double)9.0, (double)7.0, (double)5.0, (double)10.0, (double)9.0), Block.box((double)3.5, (double)0.0, (double)7.0, (double)4.5, (double)10.0, (double)9.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0));
    private static final VoxelShape SHAPE_EW = VoxelShapeUtils.rotateY(SHAPE_NS, 90);
    public static final EnumProperty<Direction> CONNECTED = EnumProperty.create((String)"connected", Direction.class);

    public KeroseneLampBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.getRotation(state).getAxis() == Direction.Axis.Z ? SHAPE_NS : SHAPE_EW;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONNECTED, BlockStateProperties.LIT});
    }

    @Override
    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return state == null ? null : (BlockState)state.setValue(CONNECTED, (Comparable)this.getConnectedDirection((LevelAccessor)ctx.getLevel(), ctx.getClickedPos()));
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.setValue(CONNECTED, (Comparable)this.getConnectedDirection(worldIn, currentPos));
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, KeroseneLampBlockEntity.class).ifPresent(KeroseneLampBlockEntity::removeLights);
        super.onRemove(state, world, pos, newState, isMoving);
    }

    private Direction getConnectedDirection(LevelAccessor world, BlockPos pos) {
        Direction connectedDir = Direction.DOWN;
        for (Direction d : DirectionUtil.VALUES) {
            BlockPos neighborPos = pos.relative(d);
            if (!Block.canSupportCenter((LevelReader)world, (BlockPos)neighborPos, (Direction)d.getOpposite())) continue;
            connectedDir = d;
            break;
        }
        return connectedDir;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new KeroseneLampBlockEntity(pPos, pState);
    }

    public static class ItemBlockKeroseneLamp
    extends BlockItem
    implements ICustomTooltipName {
        public ItemBlockKeroseneLamp(Block blockIn) {
            super(blockIn, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return (Boolean)ConfigHelper.common().machines.keroseneLampCanUseAnyFuel.get() != false ? this.getDescriptionId() : this.getDescriptionId() + ".kerosene_only";
        }
    }
}

