/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.SmartChestBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmartChestBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape SHAPE = SmartChestBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public SmartChestBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new SmartChestBlockEntity(pPos, pState);
    }

    @Override
    public void addSerializableComponents(List<DataComponentType<?>> list) {
        super.addSerializableComponents(list);
        list.add(ModDataComponents.SMART_CHEST_SAVED.get());
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity;
        if (!willHarvest && (blockEntity = level.getBlockEntity(pos)) instanceof SmartChestBlockEntity) {
            SmartChestBlockEntity be = (SmartChestBlockEntity)blockEntity;
            PneumaticCraftUtils.forceDropContents(level, pos, be.getItemHandler());
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public static class ItemBlockBlockSmartChest
    extends BlockItem
    implements IInventoryItem {
        public ItemBlockBlockSmartChest(Block block) {
            super(block, ModItems.defaultProps());
        }

        @Override
        public void getStacksInItem(ItemStack stack, List<ItemStack> curStacks) {
            SmartChestBlockEntity.SavedData data = (SmartChestBlockEntity.SavedData)stack.getOrDefault(ModDataComponents.SMART_CHEST_SAVED, (Object)SmartChestBlockEntity.SavedData.EMPTY);
            IInventoryItem.getStacks(data.inventory(), curStacks);
        }

        @Override
        public String getTooltipPrefix(ItemStack stack) {
            return ChatFormatting.GREEN.toString();
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
            super.appendHoverText(stack, context, tooltip, flagIn);
            SmartChestBlockEntity.SavedData savedData = (SmartChestBlockEntity.SavedData)stack.get(ModDataComponents.SMART_CHEST_SAVED);
            if (savedData != null) {
                int lastSlot;
                int filterSize = savedData.filter().getSlots();
                if (filterSize > 0) {
                    tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.smartChest.filter", filterSize));
                }
                if ((lastSlot = savedData.lastSlot()) < 72) {
                    tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.smartChest.slotsClosed", 72 - lastSlot));
                }
            }
        }

        public boolean canFitInsideContainerItems() {
            return false;
        }
    }
}

