/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.heat;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IHeatTinted;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class VortexTubeBlockEntity
extends AbstractAirHandlingBlockEntity
implements IHeatTinted,
IHeatExchangingTE {
    private final IHeatExchangerLogic hotHeatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final IHeatExchangerLogic coldHeatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final IHeatExchangerLogic connectingExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    @DescSynced
    private final SyncedTemperature syncHot = new SyncedTemperature(this.hotHeatExchanger);
    @DescSynced
    private final SyncedTemperature syncCold = new SyncedTemperature(this.coldHeatExchanger);

    public VortexTubeBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.VORTEX_TUBE.get(), pos, state, PressureTier.TIER_TWO, 2000, 0);
        this.coldHeatExchanger.setThermalResistance(0.01);
        this.hotHeatExchanger.setThermalResistance(0.01);
        this.connectingExchanger.setThermalResistance(100.0);
        this.connectingExchanger.addConnectedExchanger(this.coldHeatExchanger);
        this.connectingExchanger.addConnectedExchanger(this.hotHeatExchanger);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != this.getRotation() && side != this.getRotation().getOpposite();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("coldHeat", (Tag)this.coldHeatExchanger.serializeNBT());
        tag.put("connector", (Tag)this.connectingExchanger.serializeNBT());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.coldHeatExchanger.deserializeNBT(tag.getCompound("coldHeat"));
        this.connectingExchanger.deserializeNBT(tag.getCompound("connector"));
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.connectingExchanger.tick();
        this.coldHeatExchanger.tick();
        int usedAir = (int)(this.getPressure() * 10.0f);
        if (usedAir > 0) {
            this.addAir(-usedAir);
            double generatedHeat = (double)usedAir / 10.0;
            this.coldHeatExchanger.addHeat(-generatedHeat);
            this.hotHeatExchanger.addHeat(generatedHeat);
        }
        this.syncHot.tick();
        this.syncCold.tick();
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public TintColor getColorForTintIndex(int tintIndex) {
        return switch (tintIndex) {
            case 1 -> HeatUtil.getColourForTemperature(this.syncHot.getSyncedTemp());
            case 2 -> HeatUtil.getColourForTemperature(this.syncCold.getSyncedTemp());
            default -> HeatUtil.getColourForTemperature(300);
        };
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        if (dir == null || dir == this.getRotation().getOpposite()) {
            return this.hotHeatExchanger;
        }
        if (dir == this.getRotation()) {
            return this.coldHeatExchanger;
        }
        return null;
    }

    @Override
    public void initHeatExchangersOnPlacement(Level world, BlockPos pos) {
        double temp = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)world, pos);
        this.hotHeatExchanger.setTemperature(temp);
        this.coldHeatExchanger.setTemperature(temp);
    }
}

