/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.DrillPipeBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.inventory.GasLiftMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GasLiftBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<GasLiftBlockEntity>,
ISerializableTanks,
IAutoFluidEjecting,
MenuProvider {
    private static final int INVENTORY_SIZE = 1;
    private static final int MAX_PUMP_RANGE_SQUARED = 225;
    @DescSynced
    @GuiSynced
    private final GasLiftFluidTank tank = new GasLiftFluidTank();
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || itemStack.getItem() == ((DrillPipeBlock)ModBlocks.DRILL_PIPE.get()).asItem();
        }
    };
    @GuiSynced
    public int currentDepth;
    @GuiSynced
    public final RedstoneController<GasLiftBlockEntity> rsController = new RedstoneController<GasLiftBlockEntity>(this);
    @GuiSynced
    public PumpMode pumpMode = PumpMode.PUMP_EMPTY;
    @GuiSynced
    public Status status = Status.IDLE;
    private float workTimer;
    private Deque<BlockPos> pumpingLake = new ArrayDeque<BlockPos>();

    public GasLiftBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.GAS_LIFT.get(), pos, state, PressureTier.TIER_ONE, 3000, 4);
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return this.tank;
    }

    @Override
    public boolean canConnectPneumatic(Direction d) {
        return d != Direction.DOWN;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickServer() {
        int curCheckingPipe;
        super.tickServer();
        if (this.currentDepth > 0 && (curCheckingPipe = (int)(this.nonNullLevel().getGameTime() % (long)this.currentDepth)) > 0 && !this.isPipe(this.nonNullLevel(), this.getBlockPos().relative(Direction.DOWN, curCheckingPipe))) {
            this.currentDepth = curCheckingPipe - 1;
        }
        if (this.rsController.shouldRun() && this.getPressure() >= this.getMinWorkingPressure()) {
            this.workTimer += this.getSpeedMultiplierFromUpgrades();
            while (this.workTimer > 20.0f) {
                this.workTimer -= 20.0f;
                this.status = Status.IDLE;
                if (this.pumpMode == PumpMode.RETRACT) {
                    this.retractPipes();
                    continue;
                }
                if (this.suckLiquid() || this.tryDigDown()) continue;
                break;
            }
        } else {
            this.status = Status.IDLE;
        }
    }

    private void retractPipes() {
        if (this.currentDepth > 0) {
            this.status = Status.RETRACTING;
            Level level = this.nonNullLevel();
            if (this.isPipe(level, this.getBlockPos().offset(0, -this.currentDepth, 0))) {
                BlockPos pos1 = this.getBlockPos().relative(Direction.DOWN, this.currentDepth);
                ItemStack toInsert = new ItemStack((ItemLike)level.getBlockState(pos1).getBlock());
                if (this.inventory.insertItem(0, toInsert, true).isEmpty()) {
                    this.inventory.insertItem(0, toInsert, false);
                    level.destroyBlock(pos1, false);
                    this.addAir(-100);
                    --this.currentDepth;
                } else {
                    this.status = Status.IDLE;
                }
            } else {
                --this.currentDepth;
            }
        }
    }

    private boolean tryDigDown() {
        if (this.isUnbreakable(this.getBlockPos().relative(Direction.DOWN, this.currentDepth + 1))) {
            this.status = Status.STUCK;
        } else if (this.getBlockPos().getY() - this.currentDepth >= this.nonNullLevel().getMinBuildHeight()) {
            this.status = Status.DIGGING;
            ++this.currentDepth;
            BlockPos pos1 = this.getBlockPos().relative(Direction.DOWN, this.currentDepth);
            Level level = this.nonNullLevel();
            if (!this.isPipe(level, pos1)) {
                ItemStack extracted = this.inventory.extractItem(0, 1, true);
                if (extracted.getItem() == ((DrillPipeBlock)ModBlocks.DRILL_PIPE.get()).asItem()) {
                    BlockState currentState = level.getBlockState(pos1);
                    BlockState newState = ((BlockItem)extracted.getItem()).getBlock().defaultBlockState();
                    int airRequired = Math.round(66.66f * currentState.getDestroySpeed((BlockGetter)level, pos1));
                    if (this.airHandler.getAir() > airRequired) {
                        this.inventory.extractItem(0, 1, false);
                        level.destroyBlock(pos1, false);
                        level.setBlockAndUpdate(pos1, newState);
                        this.workTimer = 19.0f;
                        this.addAir(-airRequired);
                    } else {
                        this.status = Status.IDLE;
                        --this.currentDepth;
                    }
                } else {
                    this.status = Status.IDLE;
                    --this.currentDepth;
                }
            }
        } else {
            this.status = Status.IDLE;
        }
        return this.status == Status.DIGGING;
    }

    private boolean isPipe(Level world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() == ModBlocks.DRILL_PIPE.get();
    }

    private boolean isUnbreakable(BlockPos pos) {
        return this.nonNullLevel().getBlockState(pos).getDestroySpeed((BlockGetter)this.nonNullLevel(), pos) < 0.0f;
    }

    private boolean suckLiquid() {
        BlockPos pos = this.getBlockPos().relative(Direction.DOWN, this.currentDepth + 1);
        Level level = this.nonNullLevel();
        FluidState fluidState = level.getFluidState(pos);
        if (fluidState.getType() == Fluids.EMPTY) {
            return false;
        }
        FluidStack fluidStack = new FluidStack(fluidState.getType(), 1000);
        if (this.tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == fluidStack.getAmount()) {
            FluidStack taken;
            if (this.pumpingLake.isEmpty()) {
                this.findLake(fluidStack.getFluid());
            }
            BlockPos curPos = null;
            while (!this.pumpingLake.isEmpty() && !FluidUtils.isSourceFluidBlock(level, curPos = this.pumpingLake.peek(), fluidStack.getFluid())) {
                this.pumpingLake.pop();
            }
            if (curPos != null && (taken = FluidUtils.tryPickupFluid(this.tank, level, curPos, false, IFluidHandler.FluidAction.EXECUTE)).getAmount() == 1000) {
                this.addAir(-100);
                this.status = Status.PUMPING;
            }
        }
        return true;
    }

    private void findLake(Fluid fluid) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>();
        BlockPos thisPos = this.getBlockPos().relative(Direction.DOWN, this.currentDepth + 1);
        pendingPositions.add(thisPos);
        result.add(thisPos);
        while (!pendingPositions.isEmpty()) {
            BlockPos checkingPos = (BlockPos)pendingPositions.pop();
            for (Direction d : DirectionUtil.VALUES) {
                BlockPos newPos;
                if (d == Direction.DOWN || !(PneumaticCraftUtils.distBetweenSq(newPos = checkingPos.relative(d), thisPos) <= 225.0) || !FluidUtils.isSourceFluidBlock(this.nonNullLevel(), newPos, fluid) || result.contains(newPos)) continue;
                pendingPositions.add(newPos);
                result.add(newPos);
            }
        }
        this.pumpingLake = result.stream().sorted((o1, o2) -> (int)o2.distSqr((Vec3i)this.getBlockPos()) - (int)o1.distSqr((Vec3i)this.getBlockPos())).collect(Collectors.toCollection(() -> new ArrayDeque(result.size())));
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        try {
            this.pumpMode = PumpMode.valueOf(tag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public RedstoneController<GasLiftBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f + (float)this.currentDepth * 0.025f;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Items", (Tag)this.inventory.serializeNBT(provider));
        tag.putString("mode", this.pumpMode.toString());
        tag.putInt("currentDepth", this.currentDepth);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.deserializeNBT(provider, tag.getCompound("Items"));
        if (tag.contains("mode")) {
            this.pumpMode = PumpMode.valueOf(tag.getString("mode"));
        }
        this.currentDepth = tag.getInt("currentDepth");
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new GasLiftMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.MAIN_TANK.get(), this.tank);
    }

    private class GasLiftFluidTank
    extends SmartSyncTank {
        GasLiftFluidTank() {
            super(GasLiftBlockEntity.this, 16000);
        }

        @Override
        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int inTank = this.fluidStack.getAmount();
            int amount = GasLiftBlockEntity.this.pumpMode == PumpMode.PUMP_LEAVE_FLUID ? Math.max(0, inTank - 1) : inTank;
            return super.drain(Math.min(maxDrain, amount), action);
        }
    }

    public static enum PumpMode {
        PUMP_EMPTY,
        PUMP_LEAVE_FLUID,
        RETRACT;

    }

    public static enum Status implements ITranslatableEnum
    {
        IDLE("idling"),
        PUMPING("pumping"),
        DIGGING("diggingDown"),
        RETRACTING("retracting"),
        STUCK("stuck");

        private final String desc;

        private Status(String desc) {
            this.desc = desc;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.status.gasLift.action." + this.desc;
        }
    }
}

