/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ProgWidgetUtils;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetExternalProgram;
import me.desht.pneumaticcraft.common.drone.progwidgets.SavedDroneProgram;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneProgWidgets;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class DroneAIExternalProgram
extends DroneAIBlockInteraction<ProgWidgetExternalProgram> {
    private final DroneAIManager subAI;
    private final DroneAIManager mainAI;
    private final Set<BlockPos> traversedPositions = new HashSet<BlockPos>();
    private int curSlot;
    private int curProgramHash;

    public DroneAIExternalProgram(IDrone drone, DroneAIManager mainAI, ProgWidgetExternalProgram widget) {
        super(drone, widget);
        this.mainAI = mainAI;
        this.subAI = new DroneAIManager(drone, new ArrayList<IProgWidget>());
    }

    @Override
    public boolean canUse() {
        if (super.canUse()) {
            this.traversedPositions.clear();
            return true;
        }
        return false;
    }

    @Override
    protected boolean moveToPositions() {
        return false;
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.traversedPositions.add(pos)) {
            this.curSlot = 0;
            BlockEntity te = this.drone.getDroneLevel().getBlockEntity(pos);
            return te != null && IOHelper.getInventoryForBlock(te).isPresent();
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return IOHelper.getInventoryForBlock(this.drone.getDroneLevel().getBlockEntity(pos)).map(this::handleInv).orElse(false);
    }

    private boolean handleInv(IItemHandler inv) {
        if (this.curProgramHash != 0) {
            if (this.curSlot < inv.getSlots()) {
                ItemStack stack = inv.getStackInSlot(this.curSlot);
                if (this.curProgramHash == ItemStack.hashItemAndComponents((ItemStack)stack)) {
                    this.subAI.onUpdateTasks();
                    if (this.subAI.isIdling() || this.isRunningSameProgram(this.subAI.getCurrentGoal())) {
                        this.curProgramHash = 0;
                        ++this.curSlot;
                    }
                } else {
                    this.curProgramHash = 0;
                    this.subAI.setWidgets(new ArrayList<IProgWidget>());
                    IDrone iDrone = this.drone;
                    if (iDrone instanceof IDroneBase) {
                        IDroneBase base = (IDroneBase)iDrone;
                        this.drone.getDebugger().getDebuggingPlayers().forEach(p -> NetworkHandler.sendToPlayer(PacketSyncDroneProgWidgets.create(base), p));
                    }
                }
            }
            return true;
        }
        while (this.curSlot < inv.getSlots()) {
            IProgrammable programmable;
            ItemStack stack = inv.getStackInSlot(this.curSlot);
            Item item = stack.getItem();
            if (item instanceof IProgrammable && (programmable = (IProgrammable)item).canProgram(stack) && programmable.usesPieces(stack)) {
                List<IProgWidget> widgets = SavedDroneProgram.loadProgWidgets(stack);
                ProgWidgetUtils.updatePuzzleConnections(widgets);
                boolean areWidgetsValid = widgets.stream().allMatch(widget -> this.drone.isProgramApplicable(widget.getType()));
                if (areWidgetsValid) {
                    if (((ProgWidgetExternalProgram)this.progWidget).shareVariables) {
                        this.mainAI.connectVariables(this.subAI);
                    }
                    IDroneBase droneBase = IDroneBase.asDroneBase(this.subAI.getDrone());
                    droneBase.getAIManager().setLabel("Main");
                    this.subAI.setWidgets(widgets);
                    this.drone.getDebugger().getDebuggingPlayers().forEach(p -> NetworkHandler.sendToPlayer(PacketSyncDroneProgWidgets.create(droneBase), p));
                    this.curProgramHash = ItemStack.hashItemAndComponents((ItemStack)stack);
                    if (!this.subAI.isIdling()) {
                        return true;
                    }
                }
            }
            ++this.curSlot;
        }
        this.abort();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRunningSameProgram(Goal ai) {
        if (!(ai instanceof DroneAIExternalProgram)) return false;
        DroneAIExternalProgram ext = (DroneAIExternalProgram)ai;
        if (this.curProgramHash != ext.curProgramHash) return false;
        return true;
    }

    public DroneAIManager getRunningAI() {
        return this.subAI;
    }
}

