/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.AxisOptions;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class ProgWidgetCoordinateCondition
extends ProgWidgetConditionBase {
    public static final MapCodec<ProgWidgetCoordinateCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetCoordinateCondition.baseParts(builder).and(builder.group((App)AxisOptions.CODEC.fieldOf("axis_options").forGetter(ProgWidgetCoordinateCondition::getAxisOptions), (App)StringRepresentable.fromEnum(ICondition.Operator::values).fieldOf("cond_op").forGetter(ProgWidgetCoordinateCondition::getOperator))).apply((Applicative)builder, ProgWidgetCoordinateCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetCoordinateCondition> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, AxisOptions.STREAM_CODEC, ProgWidgetCoordinateCondition::getAxisOptions, (StreamCodec)NeoForgeStreamCodecs.enumCodec(ICondition.Operator.class), ProgWidgetCoordinateCondition::getOperator, ProgWidgetCoordinateCondition::new);
    private final AxisOptions axisOptions;
    private ICondition.Operator operator;

    public ProgWidgetCoordinateCondition() {
        super(ProgWidget.PositionFields.DEFAULT);
        this.axisOptions = new AxisOptions(false, false, false);
        this.operator = ICondition.Operator.GE;
    }

    private ProgWidgetCoordinateCondition(ProgWidget.PositionFields pos, AxisOptions options, ICondition.Operator op) {
        super(pos);
        this.axisOptions = options;
        this.operator = op;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetCoordinateCondition(this.getPosition(), this.axisOptions.copy(), this.operator);
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.COORDINATE.get(), ModProgWidgetTypes.COORDINATE.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (!(this.axisOptions.shouldCheck(Direction.Axis.X) || this.axisOptions.shouldCheck(Direction.Axis.Y) || this.axisOptions.shouldCheck(Direction.Axis.Z))) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionCoordinate.error.noAxisSelected", new Object[0]));
        }
    }

    @Override
    public boolean evaluate(IDrone drone, IProgWidget widget) {
        BlockPos pos1 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 0, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        BlockPos pos2 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 1, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        return !(this.axisOptions.shouldCheck(Direction.Axis.X) && !this.evaluate(pos1.getX(), pos2.getX()) || this.axisOptions.shouldCheck(Direction.Axis.Y) && !this.evaluate(pos1.getY(), pos2.getY()) || this.axisOptions.shouldCheck(Direction.Axis.Z) && !this.evaluate(pos1.getZ(), pos2.getZ()));
    }

    public AxisOptions getAxisOptions() {
        return this.axisOptions;
    }

    private boolean evaluate(int arg1, int arg2) {
        return this.operator.evaluate(arg1, arg2);
    }

    public ICondition.Operator getOperator() {
        return this.operator;
    }

    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_COORDINATE;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.CONDITION_COORDINATE.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)Component.literal((String)("Condition: \"" + this.getCondition() + "\"")));
    }

    @Override
    public List<Component> getExtraStringInfo() {
        String condition = this.getCondition();
        return condition.isEmpty() ? Collections.emptyList() : Collections.singletonList(Component.literal((String)condition));
    }

    public String getCondition() {
        return Arrays.stream(Direction.Axis.values()).filter(this.axisOptions::shouldCheck).map(axis -> String.format("%1$s1 %2$s %1$s2", axis.getName(), this.operator.toString())).collect(Collectors.joining(" and "));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetCoordinateCondition that = (ProgWidgetCoordinateCondition)o;
        return this.baseEquals(that) && Objects.equals(this.axisOptions, that.axisOptions) && this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.axisOptions, this.operator});
    }
}

