/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIDropItem;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemDropper;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetDropItem
extends ProgWidgetInventoryBase
implements IItemDropper {
    public static final MapCodec<ProgWidgetDropItem> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetDropItem.invParts(builder).and(builder.group((App)Codec.BOOL.optionalFieldOf("drop_straight", (Object)false).forGetter(ProgWidgetDropItem::dropStraight), (App)Codec.BOOL.optionalFieldOf("pick_delay", (Object)false).forGetter(ProgWidgetDropItem::hasPickupDelay))).apply((Applicative)builder, ProgWidgetDropItem::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetDropItem> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetDropItem::dropStraight, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetDropItem::hasPickupDelay, ProgWidgetDropItem::new);
    private boolean dropStraight;
    private boolean pickupDelay;

    public ProgWidgetDropItem(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields invBaseFields, boolean dropStraight, boolean pickupDelay) {
        super(pos, invBaseFields);
        this.dropStraight = dropStraight;
        this.pickupDelay = pickupDelay;
    }

    public ProgWidgetDropItem() {
        super(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT);
        this.dropStraight = false;
        this.pickupDelay = true;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetDropItem(this.getPosition(), this.invBaseFields(), this.dropStraight, this.pickupDelay);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.MAGENTA;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_DROP_ITEM;
    }

    @Override
    public boolean dropStraight() {
        return this.dropStraight;
    }

    @Override
    public void setDropStraight(boolean dropStraight) {
        this.dropStraight = dropStraight;
    }

    @Override
    public boolean hasPickupDelay() {
        return this.pickupDelay;
    }

    @Override
    public void setPickupDelay(boolean pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.DROP_ITEM.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.pickupDelay) {
            curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.drop.hasPickupDelay"));
        } else {
            curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.drop.noPickupDelay"));
        }
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIDropItem<ProgWidgetInventoryBase>(drone, (ProgWidgetInventoryBase)widget);
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return List.of(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.drop.dropMethod." + (this.dropStraight() ? "straight" : "random"), new Object[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetDropItem that = (ProgWidgetDropItem)o;
        return this.baseEquals(that) && this.dropStraight == that.dropStraight && this.pickupDelay == that.pickupDelay;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.dropStraight, this.pickupDelay);
    }
}

