/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneEntityAIGoToLocation;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IGotoWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetGoToLocation
extends ProgWidget
implements IGotoWidget,
IAreaProvider {
    public static final MapCodec<ProgWidgetGoToLocation> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetGoToLocation.baseParts(builder).and((App)Codec.BOOL.optionalFieldOf("done_when_depart", (Object)false).forGetter(ProgWidgetGoToLocation::doneWhenDeparting)).apply((Applicative)builder, ProgWidgetGoToLocation::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetGoToLocation> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetGoToLocation::doneWhenDeparting, ProgWidgetGoToLocation::new);
    private boolean doneWhenDeparting;

    protected ProgWidgetGoToLocation(ProgWidget.PositionFields pos, boolean doneWhenDeparting) {
        super(pos);
        this.doneWhenDeparting = doneWhenDeparting;
    }

    public ProgWidgetGoToLocation() {
        this(ProgWidget.PositionFields.DEFAULT, false);
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
    }

    @Override
    public boolean doneWhenDeparting() {
        return this.doneWhenDeparting;
    }

    @Override
    public void setDoneWhenDeparting(boolean bool) {
        this.doneWhenDeparting = bool;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.GOTO.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.goto.doneWhen" + (this.doneWhenDeparting ? "Departing" : "Arrived"), new Object[0]));
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_GOTO;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneEntityAIGoToLocation(drone, (ProgWidget)widget);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get());
    }

    @Override
    public Set<BlockPos> getArea(Set<BlockPos> area) {
        return ProgWidgetAreaItemBase.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().size()]);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.LIGHT_BLUE;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetGoToLocation(this.getPosition(), this.doneWhenDeparting);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetGoToLocation that = (ProgWidgetGoToLocation)o;
        return this.baseEquals(that) && this.doneWhenDeparting == that.doneWhenDeparting;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.doneWhenDeparting);
    }
}

