/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIHarvest;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDigAndPlace;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetHarvest
extends ProgWidgetDigAndPlace
implements IToolUser {
    public static final MapCodec<ProgWidgetHarvest> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetHarvest.digPlaceParts(builder).and((App)Codec.BOOL.optionalFieldOf("require_hoe", (Object)false).forGetter(ProgWidgetHarvest::requiresTool)).apply((Applicative)builder, ProgWidgetHarvest::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetHarvest> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetDigAndPlace.DigPlaceFields.STREAM_CODEC, p -> p.digPlaceFields, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetHarvest::requiresTool, ProgWidgetHarvest::new);
    private boolean requireHoe;

    public ProgWidgetHarvest(ProgWidget.PositionFields pos, ProgWidgetDigAndPlace.DigPlaceFields digPlaceFields, boolean requireHoe) {
        super(pos, digPlaceFields);
        this.requireHoe = requireHoe;
    }

    public ProgWidgetHarvest() {
        super(ProgWidget.PositionFields.DEFAULT, ProgWidgetDigAndPlace.DigPlaceFields.makeDefault(IBlockOrdered.Ordering.CLOSEST));
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetHarvest(this.getPosition(), this.digPlaceFields, this.requireHoe);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_HARVEST;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIHarvest<ProgWidgetAreaItemBase>(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.BROWN;
    }

    @Override
    public boolean requiresTool() {
        return this.requireHoe;
    }

    @Override
    public void setRequiresTool(boolean requireHoe) {
        this.requireHoe = requireHoe;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.HARVEST.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.requiresTool()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.harvest.requiresHoe", new Object[0]));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetHarvest that = (ProgWidgetHarvest)o;
        return this.baseEquals(that) && this.requireHoe == that.requireHoe;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.requireHoe);
    }
}

