/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILabel;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetLabel
extends ProgWidget
implements ILabel {
    public static final MapCodec<ProgWidgetLabel> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetLabel.baseParts(builder).apply((Applicative)builder, ProgWidgetLabel::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetLabel> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetLabel::new);

    public ProgWidgetLabel(ProgWidget.PositionFields pos) {
        super(pos);
    }

    public ProgWidgetLabel() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetLabel(this.getPosition());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.LABEL.get();
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.label.error.noLabel", new Object[0]));
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public boolean hasStepOutput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_LABEL;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.MEDIUM;
    }

    @Override
    public String getLabel() {
        ProgWidgetText labelWidget = (ProgWidgetText)this.getConnectedParameters()[0];
        return labelWidget != null ? labelWidget.string : null;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.WHITE;
    }
}

