/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IRenamingWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.TextVariableParser;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetRename
extends ProgWidget
implements IRenamingWidget,
IVariableWidget {
    public static final MapCodec<ProgWidgetRename> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetRename.baseParts(builder).apply((Applicative)builder, ProgWidgetRename::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetRename> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetRename::new);
    private DroneAIManager aiManager;

    public ProgWidgetRename(ProgWidget.PositionFields pos) {
        super(pos);
    }

    public ProgWidgetRename() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetRename(this.getPosition());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.RENAME.get();
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.WHITE;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_RENAME;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIRename(drone, (IRenamingWidget)((Object)widget));
    }

    @Override
    public String getNewName() {
        return this.getConnectedParameters()[0] != null ? new TextVariableParser(((ProgWidgetText)this.getConnectedParameters()[0]).string, this.aiManager).parse() : null;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
    }

    private static class DroneAIRename
    extends Goal {
        private final IDrone drone;
        private final IRenamingWidget widget;

        DroneAIRename(IDrone drone, IRenamingWidget widget) {
            this.drone = drone;
            this.widget = widget;
        }

        public boolean canUse() {
            this.drone.setName((Component)(this.widget.getNewName() != null ? Component.literal((String)this.widget.getNewName()) : PneumaticCraftUtils.xlate("entity.pneumaticcraft.drone", new Object[0])));
            return false;
        }
    }
}

