/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetAreaTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class AreaTypePyramid
extends AreaType {
    public static final MapCodec<AreaTypePyramid> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)StringRepresentable.fromEnum(AreaType.AreaAxis::values).optionalFieldOf("axis", (Object)AreaType.AreaAxis.X).forGetter(t -> t.axis), (App)StringRepresentable.fromEnum(PyramidType::values).optionalFieldOf("pyramid_type", (Object)PyramidType.FILLED).forGetter(t -> t.pyramidType)).apply((Applicative)builder, AreaTypePyramid::new));
    public static final StreamCodec<FriendlyByteBuf, AreaTypePyramid> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(AreaType.AreaAxis.class), t -> t.axis, (StreamCodec)NeoForgeStreamCodecs.enumCodec(PyramidType.class), t -> t.pyramidType, AreaTypePyramid::new);
    public static final String ID = "pyramid";
    private AreaType.AreaAxis axis;
    private PyramidType pyramidType;

    public AreaTypePyramid() {
        this(AreaType.AreaAxis.X, PyramidType.FILLED);
    }

    public AreaTypePyramid(AreaType.AreaAxis axis, PyramidType pyramidType) {
        super(ID);
        this.axis = axis;
        this.pyramidType = pyramidType;
    }

    @Override
    public AreaType copy() {
        return new AreaTypePyramid(this.axis, this.pyramidType);
    }

    @Override
    public AreaTypeSerializer<? extends AreaType> getSerializer() {
        return ModProgWidgetAreaTypes.AREA_TYPE_PYRAMID.get();
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                if (p2.getX() == p1.getX()) break;
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()), (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x, lineVec.y / lineVec.x, lineVec.z / lineVec.x);
                double curY = (double)p1.getY() - lineVec.y;
                int x = p1.getX() + (p2.getX() > p1.getX() ? -1 : 1);
                double curZ = (double)p1.getZ() - lineVec.z;
                int prevDY = -1;
                int prevDZ = -1;
                while (x != p2.getX()) {
                    x += p2.getX() > p1.getX() ? 1 : -1;
                    int dY = Math.abs((int)((curY += lineVec.y) - (double)p1.getY()));
                    int dZ = Math.abs((int)((curZ += lineVec.z) - (double)p1.getZ()));
                    if (dY == prevDY) {
                        --prevDY;
                    }
                    if (dZ == prevDZ) {
                        --prevDZ;
                    }
                    for (int y = p1.getY() - dY; y <= p1.getY() + dY; ++y) {
                        for (int z = p1.getZ() - dZ; z <= p1.getZ() + dZ; ++z) {
                            if (this.pyramidType != PyramidType.FILLED && x != p2.getX() && z >= p1.getZ() - prevDZ && z <= p1.getZ() + prevDZ && y >= p1.getY() - prevDY && y <= p1.getY() + prevDY) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDY = dY;
                    prevDZ = dZ;
                }
                break;
            }
            case Y: {
                if (p2.getY() == p1.getY()) break;
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()), (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x / lineVec.y, lineVec.y, lineVec.z / lineVec.y);
                double curX = (double)p1.getX() - lineVec.x;
                int y = p1.getY() + (p2.getY() > p1.getY() ? -1 : 1);
                double curZ = (double)p1.getZ() - lineVec.z;
                int prevDX = -1;
                int prevDZ = -1;
                while (y != p2.getY()) {
                    y += p2.getY() > p1.getY() ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.x) - (double)p1.getX()));
                    int dZ = Math.abs((int)((curZ += lineVec.z) - (double)p1.getZ()));
                    if (dX == prevDX) {
                        --prevDX;
                    }
                    if (dZ == prevDZ) {
                        --prevDZ;
                    }
                    int miniX = p1.getX() - dX;
                    int maxiX = p1.getX() + dX;
                    int miniZ = p1.getZ() - dZ;
                    int maxiZ = p1.getZ() + dZ;
                    for (int x = miniX; x <= maxiX; ++x) {
                        for (int z = miniZ; z <= maxiZ; ++z) {
                            if (this.pyramidType != PyramidType.FILLED && y != p2.getY() && z >= p1.getZ() - prevDZ && z <= p1.getZ() + prevDZ && x >= p1.getX() - prevDX && x <= p1.getX() + prevDX) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDX = dX;
                    prevDZ = dZ;
                }
                break;
            }
            case Z: {
                if (p2.getZ() == p1.getZ()) break;
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()), (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x / lineVec.z, lineVec.y / lineVec.z, lineVec.z);
                double curX = (double)p1.getX() - lineVec.x;
                int z = p1.getZ() + (p2.getZ() > p1.getZ() ? -1 : 1);
                double curY = (double)p1.getY() - lineVec.y;
                int prevDX = -1;
                int prevDY = -1;
                while (z != p2.getZ()) {
                    z += p2.getZ() > p1.getZ() ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.x) - (double)p1.getX()));
                    int dY = Math.abs((int)((curY += lineVec.y) - (double)p1.getY()));
                    if (dX == prevDX) {
                        --prevDX;
                    }
                    if (dY == prevDY) {
                        --prevDY;
                    }
                    for (int x = p1.getX() - dX; x <= p1.getX() + dX; ++x) {
                        for (int y = p1.getY() - dY; y <= p1.getY() + dY; ++y) {
                            if (this.pyramidType != PyramidType.FILLED && z != p2.getZ() && x >= p1.getX() - prevDX && x <= p1.getX() + prevDX && y >= p1.getY() - prevDY && y <= p1.getY() + prevDY) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDX = dX;
                    prevDY = dY;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    public String toString() {
        return this.getName() + "/" + String.valueOf(this.pyramidType) + "/" + String.valueOf(this.axis);
    }

    @Override
    public void convertFromLegacy(EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_PYRAMID: {
                this.axis = AreaType.AreaAxis.X;
                break;
            }
            case Y_PYRAMID: {
                this.axis = AreaType.AreaAxis.Y;
                break;
            }
            case Z_PYRAMID: {
                this.axis = AreaType.AreaAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaTypeWidget.EnumSelectorField<AreaType.AreaAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.AreaAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
        widgets.add(new AreaTypeWidget.EnumSelectorField<PyramidType>("pneumaticcraft.gui.progWidget.area.type.pyramid.pyramidType", PyramidType.class, () -> this.pyramidType, pyramidType -> {
            this.pyramidType = pyramidType;
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaTypePyramid that = (AreaTypePyramid)o;
        return this.axis == that.axis && this.pyramidType == that.pyramidType;
    }

    public int hashCode() {
        return Objects.hash(this.axis, this.pyramidType);
    }

    public static enum PyramidType implements ITranslatableEnum,
    StringRepresentable
    {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private PyramidType(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.area.type.pyramid.pyramidType." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

