/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import java.util.List;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.fluid.PNCFluidRenderProps;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public class FluidYeastCulture {
    public static final PNCFluidRenderProps RENDER_PROPS = PNCFluidRenderProps.thickFluid(-1912136);

    private static BaseFlowingFluid.Properties props() {
        return new BaseFlowingFluid.Properties(ModFluids.YEAST_CULTURE_FLUID_TYPE, ModFluids.YEAST_CULTURE, ModFluids.YEAST_CULTURE_FLOWING).block(ModBlocks.YEAST_CULTURE).bucket(ModItems.YEAST_CULTURE_BUCKET).tickRate(30);
    }

    public static class Flowing
    extends BaseFlowingFluid.Flowing {
        public Flowing() {
            super(FluidYeastCulture.props());
        }
    }

    public static class Source
    extends BaseFlowingFluid.Source {
        public Source() {
            super(FluidYeastCulture.props());
        }

        public void tick(Level worldIn, BlockPos pos, FluidState state) {
            List entities;
            if (((Boolean)ConfigHelper.common().recipes.inWorldYeastCrafting.get()).booleanValue() && !(entities = worldIn.getEntitiesOfClass(ItemEntity.class, new AABB(pos), e -> e.getItem().getItem() == Items.SUGAR)).isEmpty()) {
                for (Direction d : DirectionUtil.VALUES) {
                    BlockPos pos1 = pos.relative(d);
                    FluidState fluidState = worldIn.getFluidState(pos1);
                    if (!fluidState.isSource() || !fluidState.is(FluidTags.WATER) || worldIn.getBlockState(pos1).getBlock() != Blocks.WATER) continue;
                    worldIn.setBlock(pos1, ModFluids.YEAST_CULTURE.get().defaultFluidState().createLegacyBlock(), 3);
                    ItemEntity sugarItemEntity = (ItemEntity)entities.getFirst();
                    sugarItemEntity.getItem().shrink(1);
                    if (!sugarItemEntity.getItem().isEmpty()) break;
                    sugarItemEntity.discard();
                    break;
                }
            }
            super.tick(worldIn, pos, state);
        }
    }
}

