/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class HackableCow
implements IHackableEntity<Cow> {
    private static final ResourceLocation ID = PneumaticRegistry.RL("cow");

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    @NotNull
    public Class<Cow> getHackableClass() {
        return Cow.class;
    }

    @Override
    public boolean canHack(Entity entity, Player player) {
        return IHackableEntity.super.canHack(entity, player) && !(entity instanceof MushroomCow);
    }

    @Override
    public void addHackInfo(Cow entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.fungiInfuse", new Object[0]));
    }

    @Override
    public void addPostHackInfo(Cow entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.fungiInfusion", new Object[0]));
    }

    @Override
    public int getHackTime(Cow entity, Player player) {
        return 100;
    }

    @Override
    public void onHackFinished(Cow entity, Player player) {
        if (!entity.level().isClientSide) {
            entity.discard();
            MushroomCow entitycow = new MushroomCow(EntityType.MOOSHROOM, entity.level());
            entitycow.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
            entitycow.setHealth(entity.getHealth());
            entitycow.yBodyRot = entity.yBodyRot;
            entity.level().addFreshEntity((Entity)entitycow);
            entity.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 0.0, 0.0, 0.0);
        }
    }
}

