/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class HackableSquid
implements IHackableEntity<Squid> {
    private static final ResourceLocation ID = PneumaticRegistry.RL("squid");

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    @NotNull
    public Class<Squid> getHackableClass() {
        return Squid.class;
    }

    @Override
    public void addHackInfo(Squid entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.changeColor", new Object[0]));
    }

    @Override
    public void addPostHackInfo(Squid entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.changeColor", new Object[0]));
    }

    @Override
    public int getHackTime(Squid entity, Player player) {
        return 60;
    }

    @Override
    public void onHackFinished(Squid entity, Player player) {
        if (!entity.level().isClientSide) {
            entity.discard();
            GlowSquid glowSquid = new GlowSquid(EntityType.GLOW_SQUID, entity.level());
            glowSquid.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
            glowSquid.setHealth(entity.getHealth());
            glowSquid.yBodyRot = entity.yBodyRot;
            entity.level().addFreshEntity((Entity)glowSquid);
            entity.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 0.0, 0.0, 0.0);
        }
    }
}

