/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.slot.UnstackablePhantomSlot;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class AmadronAddTradeMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity>
implements IGUIButtonSensitive {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private final ItemStackHandler inv = new ItemStackHandler(2);

    AmadronAddTradeMenu(int windowId, Inventory playerInventory) {
        super(ModMenuTypes.AMADRON_ADD_TRADE.get(), windowId, playerInventory);
        this.addSlot((Slot)new UnstackablePhantomSlot((IItemHandler)this.inv, 0, 37, 90));
        this.addSlot((Slot)new UnstackablePhantomSlot((IItemHandler)this.inv, 1, 126, 90));
    }

    public AmadronAddTradeMenu(int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(windowId, invPlayer);
    }

    public void setStack(int index, @Nonnull ItemStack stack) {
        this.inv.setStackInSlot(index, stack);
    }

    @Nonnull
    public ItemStack getStack(int index) {
        return this.inv.getStackInSlot(index);
    }

    @Nonnull
    public ItemStack getInputStack() {
        return this.inv.getStackInSlot(0);
    }

    @Nonnull
    public ItemStack getOutputStack() {
        return this.inv.getStackInSlot(1);
    }

    @Override
    public boolean stillValid(Player player) {
        return this.getHand(player) != null;
    }

    public void setItem(int slot, int state, @Nonnull ItemStack stack) {
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer playerIn) {
        if (tag.equals("showAmadron")) {
            AmadronTabletItem.openGui(playerIn, this.getHand((Player)playerIn));
        }
    }

    private InteractionHand getHand(Player player) {
        if (player.getMainHandItem().getItem() == ModItems.AMADRON_TABLET.get()) {
            return InteractionHand.MAIN_HAND;
        }
        if (player.getOffhandItem().getItem() == ModItems.AMADRON_TABLET.get()) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }
}

