/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.function.Predicate;
import me.desht.pneumaticcraft.client.gui.SecurityStationInventoryScreen;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.slot.ItemFilteredSlot;
import me.desht.pneumaticcraft.common.item.NetworkComponentItem;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class SecurityStationMainMenu
extends AbstractPneumaticCraftMenu<SecurityStationBlockEntity> {
    public SecurityStationMainMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, SecurityStationMainMenu.getTilePos(buffer));
    }

    public SecurityStationMainMenu(int windowId, Inventory playerInventory, BlockPos pos) {
        super(ModMenuTypes.SECURITY_STATION_MAIN.get(), windowId, playerInventory, pos);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.addSlot((Slot)new SlotSecurityNode(((SecurityStationBlockEntity)this.blockEntity).getItemHandler(), SecurityStationMainMenu::isSecStationComponent, j + i * 5, 17 + j * 18, 22 + i * 18));
            }
        }
        this.addUpgradeSlots(128, 62);
        this.addPlayerSlots(playerInventory, 157);
    }

    private static boolean isSecStationComponent(ItemStack stack) {
        return NetworkComponentItem.getType(stack).map(NetworkComponentItem.NetworkComponentType::isSecStationComponent).orElse(false);
    }

    private class SlotSecurityNode
    extends ItemFilteredSlot {
        SlotSecurityNode(IItemHandler handler, Predicate<ItemStack> itemAllowed, int index, int x, int y) {
            super(handler, itemAllowed, index, x, y);
        }

        public void setChanged() {
            super.setChanged();
            if (SecurityStationMainMenu.this.blockEntity != null && ((SecurityStationBlockEntity)SecurityStationMainMenu.this.blockEntity).nonNullLevel().isClientSide) {
                SecurityStationInventoryScreen.reinitConnectionRendering();
            }
        }
    }
}

