/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GPSToolScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.IGPSToolSync;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class GPSToolItem
extends Item
implements IPositionProvider,
IGPSToolSync,
IShiftScrollable {
    public GPSToolItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        if (ctx.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        GPSToolItem.setGPSLocation(ctx.getPlayer().getUUID(), ctx.getPlayer().getItemInHand(ctx.getHand()), pos);
        if (!ctx.getLevel().isClientSide) {
            GPSToolItem.displayPosition(ctx.getPlayer(), ctx.getItemInHand(), pos, false);
        }
        ctx.getPlayer().playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
        return InteractionResult.SUCCESS;
    }

    private static void displayPosition(Player player, ItemStack itemInHand, BlockPos pos, boolean actionBar) {
        player.displayClientMessage((Component)itemInHand.getDisplayName().copy().withStyle(ChatFormatting.AQUA).append(" ").append((Component)Component.translatable((String)"pneumaticcraft.message.gps_tool.targetSet", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GREEN)), actionBar);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            GPSToolScreen.showGUI(stack, handIn, GPSToolItem.getGPSLocation(playerIn.getUUID(), stack).orElse(playerIn.blockPosition()));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> infoList, TooltipFlag par4) {
        super.appendHoverText(stack, context, infoList, par4);
        ClientUtils.getOptionalClientLevel().ifPresent(level -> {
            ClientUtils.addGuiContextSensitiveTooltip(stack, infoList);
            GPSToolItem.getGPSLocation(ClientUtils.getClientPlayer().getUUID(), stack).ifPresent(pos -> {
                MutableComponent blockName;
                if (level.isLoaded(pos)) {
                    MutableComponent translated = Component.translatable((String)level.getBlockState(pos).getBlock().getDescriptionId());
                    blockName = Component.literal((String)" (").append((Component)translated).append(")");
                } else {
                    blockName = Component.empty().plainCopy();
                }
                String str = String.format("[%d, %d, %d]", pos.getX(), pos.getY(), pos.getZ());
                infoList.add((Component)Component.literal((String)str).withStyle(ChatFormatting.YELLOW).append((Component)blockName.withStyle(ChatFormatting.GREEN)));
            });
            String varName = GPSToolItem.getVariable(stack);
            if (!varName.isEmpty()) {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gpsTool.variable", varName));
            }
        });
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean heldItem) {
        String var = GPSToolItem.getVariable(stack);
        if (!var.isEmpty() && !world.isClientSide && entity instanceof Player) {
            GPSToolItem.getGPSLocation(entity.getUUID(), stack).ifPresent(curPos -> {
                BlockPos varPos = GlobalVariableHelper.getInstance().getPos(entity.getUUID(), var, PneumaticCraftUtils.invalidPos());
                if (!varPos.equals(curPos)) {
                    GPSToolItem.setGPSLocation(entity.getUUID(), stack, varPos, false);
                }
            });
        }
    }

    @Nonnull
    public static Optional<BlockPos> getGPSLocation(ItemStack stack) {
        return GPSToolItem.getGPSLocation(null, stack);
    }

    @Nonnull
    public static Optional<BlockPos> getGPSLocation(UUID playerId, ItemStack gpsTool) {
        BlockPos curPos = (BlockPos)gpsTool.get(ModDataComponents.GPS_TOOL_POS);
        if (gpsTool.getItem() == ModItems.GPS_TOOL.get() && curPos != null) {
            BlockPos pos;
            String var = GPSToolItem.getVariable(gpsTool);
            if (!var.isEmpty() && (pos = GlobalVariableHelper.getInstance().getPos(playerId, var)) != null && !curPos.equals((Object)pos)) {
                curPos = pos;
                GPSToolItem.setGPSLocation(playerId, gpsTool, pos, false);
            }
            return Optional.of(curPos);
        }
        return Optional.empty();
    }

    public static void setGPSLocation(UUID playerId, ItemStack gpsTool, BlockPos pos) {
        GPSToolItem.setGPSLocation(playerId, gpsTool, pos, true);
    }

    public static void setGPSLocation(UUID playerId, ItemStack gpsTool, BlockPos pos, boolean updateVarManager) {
        String var;
        gpsTool.set(ModDataComponents.GPS_TOOL_POS, (Object)pos);
        if (updateVarManager && !(var = GPSToolItem.getVariable(gpsTool)).isEmpty()) {
            GlobalVariableHelper.getInstance().setPos(playerId, var, pos);
        }
    }

    public static void setVariable(ItemStack gpsTool, String variable) {
        gpsTool.set(ModDataComponents.GPS_TOOL_VAR, (Object)variable);
    }

    public static String getVariable(ItemStack gpsTool) {
        return (String)gpsTool.getOrDefault(ModDataComponents.GPS_TOOL_VAR, (Object)"");
    }

    @Override
    public List<BlockPos> getStoredPositions(UUID playerId, @Nonnull ItemStack stack) {
        return GPSToolItem.getGPSLocation(playerId, stack).map(List::of).orElse(List.of());
    }

    @Override
    public int getRenderColor(int index) {
        return -1862271232;
    }

    @Override
    public void syncVariables(ServerPlayer player, ItemStack stack) {
        String varName = GPSToolItem.getVariable(stack);
        if (GlobalVariableHelper.getInstance().hasPrefix(varName)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, varName);
        }
    }

    @Override
    public void syncFromClient(Player player, ItemStack stack, int index, BlockPos pos, String varName, boolean activeIndex) {
        GPSToolItem.setVariable(stack, varName);
        GPSToolItem.setGPSLocation(player.getUUID(), stack, pos);
        if (!varName.isEmpty()) {
            GlobalVariableHelper.getInstance().setPos(player.getUUID(), varName, pos);
        }
    }

    @Override
    public void onShiftScrolled(Player player, boolean forward, InteractionHand hand) {
        if (!player.level().isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            GPSToolItem.getGPSLocation(stack).ifPresent(loc -> {
                Direction facing = Direction.orderedByNearest((Entity)player)[0];
                BlockPos newPos = loc.relative(forward ? facing : facing.getOpposite());
                GPSToolItem.setGPSLocation(player.getUUID(), stack, newPos);
                GPSToolItem.displayPosition(player, stack, newPos, true);
            });
        }
    }
}

