/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.JackhammerSetupMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.DrillBitItem;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class JackHammerItem
extends PressurizableItem
implements IChargeableContainerProvider,
ColorHandlers.ITintableItem,
IShiftScrollable {
    private static final float[] SPEED_MULT = new float[]{1.0f, 2.0f, 2.4142137f, 2.732051f, 3.0f, 3.236068f, 3.4494898f, 3.6457512f, 3.828427f, 4.0f, 4.1622777f};
    private static final Set<ItemAbility> JACKHAMMER_ABILITIES = Set.of(ItemAbilities.AXE_DIG, ItemAbilities.PICKAXE_DIG, ItemAbilities.SHOVEL_DIG, ItemAbilities.SWORD_DIG);
    private static long lastModeSwitchTime;

    public JackHammerItem() {
        super(ModItems.toolProps().component(ModDataComponents.JACKHAMMER_DIG_MODE, (Object)DigMode.MODE_1X1).component(ModDataComponents.JACKHAMMER_DRILL_BIT, (Object)ItemContainerContents.EMPTY), 120000, 12000);
    }

    public static long getLastModeSwitchTime() {
        return lastModeSwitchTime;
    }

    public static DrillBitHandler getDrillBitHandler(ItemStack stack) {
        if (stack.getItem() instanceof JackHammerItem) {
            return new DrillBitHandler(stack);
        }
        return null;
    }

    public static EnchantmentHandler getEnchantmentHandler(ItemStack stack) {
        if (stack.getItem() instanceof JackHammerItem) {
            return new EnchantmentHandler(stack);
        }
        return null;
    }

    public static DrillBitItem.DrillBitType getDrillBit(ItemStack stack) {
        DrillBitItem.DrillBitType drillBitType;
        DrillBitHandler handler = new DrillBitHandler(stack);
        Item item = handler.getStackInSlot(0).getItem();
        if (item instanceof DrillBitItem) {
            DrillBitItem bit = (DrillBitItem)item;
            drillBitType = bit.getType();
        } else {
            drillBitType = DrillBitItem.DrillBitType.NONE;
        }
        return drillBitType;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return !state.is(JackHammerItem.getDrillBit(stack).getTier().getIncorrectBlocksForDrops());
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return JACKHAMMER_ABILITIES.contains(itemAbility) && PNCCapabilities.getAirHandler(stack).map(h -> h.getPressure() > 0.1f).orElse(false) != false;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState pState, BlockPos pos, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            HitResult hitResult;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (stack.getItem() instanceof JackHammerItem && (hitResult = RayTraceUtils.getEntityLookedObject((LivingEntity)serverPlayer, PneumaticCraftUtils.getPlayerReachDistance((Player)serverPlayer))) instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                PNCCapabilities.getAirHandler(stack).ifPresent(airHandler -> {
                    float usage;
                    float air;
                    boolean magnet;
                    DigMode digMode = JackHammerItem.getDigMode(stack);
                    IntList upgrades = UpgradableItemUtils.getUpgradeList(stack, ModUpgrades.SPEED.get(), ModUpgrades.MAGNET.get());
                    int speed = upgrades.getInt(0);
                    boolean bl = magnet = upgrades.getInt(1) > 0 && digMode.isVeinMining();
                    if (digMode.getBitType().getBitQuality() > JackHammerItem.getDrillBit(stack).getBitQuality()) {
                        digMode = DigMode.MODE_1X1;
                    }
                    Set<BlockPos> brokenPos = JackHammerItem.getBreakPositions(level, pos, blockHitResult.getDirection(), (Player)serverPlayer, digMode);
                    float air0 = air = (float)airHandler.getAir();
                    float f = usage = serverPlayer.isCreative() ? 0.0f : 50.0f * SPEED_MULT[speed];
                    if (magnet) {
                        usage *= 1.1f;
                    }
                    if (air >= usage) {
                        air -= usage;
                        for (BlockPos pos1 : brokenPos) {
                            Block block;
                            boolean removed;
                            BlockEvent.BreakEvent breakEvent;
                            if (air < usage) break;
                            BlockState state1 = level.getBlockState(pos1);
                            if (state1.getDestroySpeed((BlockGetter)level, pos1) < 0.0f || (breakEvent = CommonHooks.fireBlockBreak((Level)serverPlayer.level(), (GameType)serverPlayer.gameMode.getGameModeForPlayer(), (ServerPlayer)serverPlayer, (BlockPos)pos1, (BlockState)state1)).isCanceled() || level.getBlockEntity(pos1) != null || !(removed = (state1 = (block = state1.getBlock()).playerWillDestroy(level, pos1, state1, (Player)serverPlayer)).onDestroyedByPlayer(level, pos1, (Player)serverPlayer, true, level.getFluidState(pos1)))) continue;
                            block.destroy((LevelAccessor)level, pos1, state1);
                            if (magnet) {
                                JackHammerItem.magnetHarvest(block, level, (Player)serverPlayer, pos, pos1, state1, stack);
                            } else {
                                block.playerDestroy(level, (Player)serverPlayer, pos1, state1, null, stack);
                            }
                            air -= usage;
                            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                        }
                        if (air != air0 && !serverPlayer.isCreative()) {
                            airHandler.addAir((int)(air - air0));
                        }
                    }
                });
            }
        }
        return true;
    }

    private static void magnetHarvest(Block block, Level level, Player player, BlockPos pos0, BlockPos pos, BlockState state, ItemStack stack) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)block));
        player.causeFoodExhaustion(0.005f);
        Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos0, null, (Entity)player, (ItemStack)stack);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        DrillBitItem.DrillBitType bitType = JackHammerItem.getDrillBit(stack);
        int speed = bitType == DrillBitItem.DrillBitType.NONE ? 0 : UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.SPEED.get());
        return (float)this.getAir(stack) > 0.0f ? (float)bitType.getBaseEfficiency() * SPEED_MULT[speed] : 1.0f;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, final InteractionHand handIn) {
        final ItemStack stack = playerIn.getItemInHand(handIn);
        if (!playerIn.isCrouching() || stack.getCount() != 1) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)playerIn;
            sp.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return stack.getHoverName();
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                    return new JackhammerSetupMenu(windowId, inv, handIn);
                }
            }, buf -> AbstractPneumaticCraftMenu.putHand((FriendlyByteBuf)buf, handIn));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return JackHammerItem.getDrillBit(stack) != DrillBitItem.DrillBitType.NONE && (float)this.getAir(stack) > 0.0f;
    }

    public static Set<BlockPos> getBreakPositions(Level world, BlockPos pos, Direction dir, Player player, DigMode digMode) {
        if (player.isShiftKeyDown()) {
            return new HashSet<BlockPos>();
        }
        if (digMode.isVeinMining()) {
            return new HashSet<BlockPos>(JackHammerItem.getVeinPositions(world, pos, digMode));
        }
        Direction playerHoriz = player.getDirection();
        HashSet<BlockPos> res = new HashSet<BlockPos>();
        if (digMode.atLeast(DigMode.MODE_1X2)) {
            res.add(dir.getAxis() == Direction.Axis.Y ? pos.relative(playerHoriz) : pos.below());
        }
        if (digMode.atLeast(DigMode.MODE_1X3)) {
            res.add(dir.getAxis() == Direction.Axis.Y ? pos.relative(playerHoriz.getOpposite()) : pos.above());
        }
        if (digMode.atLeast(DigMode.MODE_3X3_CROSS)) {
            switch (dir.getAxis()) {
                case X: {
                    res.add(pos.north());
                    res.add(pos.south());
                    res.add(pos.above());
                    res.add(pos.below());
                    break;
                }
                case Y: {
                    res.add(pos.north());
                    res.add(pos.south());
                    res.add(pos.west());
                    res.add(pos.east());
                    break;
                }
                case Z: {
                    res.add(pos.above());
                    res.add(pos.below());
                    res.add(pos.west());
                    res.add(pos.east());
                }
            }
        }
        if (digMode.atLeast(DigMode.MODE_3X3_FULL)) {
            switch (dir.getAxis()) {
                case X: {
                    res.add(pos.above().north());
                    res.add(pos.above().south());
                    res.add(pos.below().north());
                    res.add(pos.below().south());
                    break;
                }
                case Y: {
                    res.add(pos.north().east());
                    res.add(pos.north().west());
                    res.add(pos.south().east());
                    res.add(pos.south().west());
                    break;
                }
                case Z: {
                    res.add(pos.above().east());
                    res.add(pos.above().west());
                    res.add(pos.below().east());
                    res.add(pos.below().west());
                }
            }
        }
        res.remove(pos);
        return res;
    }

    private static List<BlockPos> getVeinPositions(Level world, BlockPos startPos, DigMode mode) {
        BlockState state = world.getBlockState(startPos);
        if (!mode.okToVeinMine(state)) {
            return Collections.emptyList();
        }
        int maxRange = (Integer)ConfigHelper.common().jackhammer.maxVeinMinerRange.get();
        int maxRangeSq = maxRange * maxRange;
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        found.add(startPos);
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        Block startBlock = state.getBlock();
        int maxBlocks = mode.getBlocksDug();
        for (int i = 0; i < found.size(); ++i) {
            BlockPos blockPos = (BlockPos)found.get(i);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-1, -1, -1), (BlockPos)blockPos.offset(1, 1, 1))) {
                if (checked.contains(pos) || mode == DigMode.MODE_VEIN_PLUS && startPos.distSqr((Vec3i)pos) > (double)maxRangeSq || !world.isLoaded(pos) || startBlock != world.getBlockState(pos).getBlock()) continue;
                BlockPos pos1 = pos.immutable();
                found.add(pos1);
                checked.add(pos1);
                if (found.size() <= maxBlocks) continue;
                return found;
            }
        }
        return found;
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, ModMenuTypes.CHARGING_JACKHAMMER.get());
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return JackHammerItem.getDrillBit(stack).getTint();
        }
        return -1;
    }

    public static DigMode getDigMode(ItemStack stack) {
        return (DigMode)stack.getOrDefault(ModDataComponents.JACKHAMMER_DIG_MODE, (Object)DigMode.MODE_1X1);
    }

    public static void setDigMode(ItemStack stack, DigMode mode) {
        stack.set(ModDataComponents.JACKHAMMER_DIG_MODE, (Object)mode);
    }

    public static DigMode cycleDigMode(ItemStack stack, boolean forward) {
        Item item = stack.getItem();
        if (item instanceof JackHammerItem) {
            DigMode currentMode;
            JackHammerItem jackHammer = (JackHammerItem)item;
            DrillBitItem.DrillBitType ourBit = JackHammerItem.getDrillBit(stack);
            DigMode newMode = currentMode = JackHammerItem.getDigMode(stack);
            if (forward) {
                newMode = currentMode == DigMode.MODE_VEIN_PLUS ? DigMode.MODE_1X1 : ((newMode = DigMode.values()[currentMode.ordinal() + 1]).getBitType().getBitQuality() <= ourBit.getBitQuality() ? newMode : DigMode.MODE_1X1);
            } else if (currentMode == DigMode.MODE_1X1) {
                for (int i = DigMode.values().length - 1; i >= 0; --i) {
                    if (DigMode.values()[i].getBitType().getBitQuality() > ourBit.getBitQuality()) continue;
                    newMode = DigMode.values()[i];
                    break;
                }
            } else {
                newMode = DigMode.values()[currentMode.ordinal() - 1];
            }
            JackHammerItem.setDigMode(stack, newMode);
            return newMode;
        }
        return null;
    }

    @Override
    public void onShiftScrolled(Player player, boolean forward, InteractionHand hand) {
        if (!player.level().isClientSide) {
            DigMode newMode = JackHammerItem.cycleDigMode(player.getItemInHand(hand), forward);
            if (newMode != null) {
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.jackhammer.mode", new Object[0]).append((Component)PneumaticCraftUtils.xlate(newMode.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.YELLOW)), true);
            }
        } else {
            lastModeSwitchTime = player.level().getGameTime();
        }
    }

    @Override
    public Optional<TagKey<Item>> getUpgradeBlacklistTag() {
        return Optional.of(PneumaticCraftTags.Items.JACKHAMMER_UPGRADE_BLACKLIST);
    }

    public static enum DigMode implements ITranslatableEnum,
    StringRepresentable
    {
        MODE_1X1("1x1", 1, DrillBitItem.DrillBitType.IRON),
        MODE_1X2("1x2", 2, DrillBitItem.DrillBitType.COMPRESSED_IRON),
        MODE_1X3("1x3", 3, DrillBitItem.DrillBitType.COMPRESSED_IRON),
        MODE_3X3_CROSS("3x3_cross", 5, DrillBitItem.DrillBitType.DIAMOND),
        MODE_VEIN("vein", 128, DrillBitItem.DrillBitType.DIAMOND),
        MODE_3X3_FULL("3x3_full", 9, DrillBitItem.DrillBitType.DIAMOND),
        MODE_VEIN_PLUS("vein_plus", 128, DrillBitItem.DrillBitType.NETHERITE);

        private final String name;
        private final int blocksDug;
        private final DrillBitItem.DrillBitType bitType;

        private DigMode(String name, int blocksDug, DrillBitItem.DrillBitType bitType) {
            this.name = name;
            this.blocksDug = blocksDug;
            this.bitType = bitType;
        }

        public String getName() {
            return this.name;
        }

        public DrillBitItem.DrillBitType getBitType() {
            return this.bitType;
        }

        public int getBlocksDug() {
            return this.blocksDug;
        }

        public ResourceLocation getGuiIcon() {
            return Textures.guiIconTexture("gui_" + this.name + ".png");
        }

        public boolean atLeast(DigMode type) {
            return type.ordinal() <= this.ordinal();
        }

        public boolean isVeinMining() {
            return this == MODE_VEIN || this == MODE_VEIN_PLUS;
        }

        public boolean okToVeinMine(BlockState state) {
            return switch (this.ordinal()) {
                case 4 -> state.is(PneumaticCraftTags.Blocks.JACKHAMMER_ORES);
                case 6 -> true;
                default -> false;
            };
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.message.jackhammer.mode." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static class DrillBitHandler
    extends BaseItemStackHandler {
        private final ItemStack jackhammerStack;

        public DrillBitHandler(ItemStack jackhammerStack) {
            super(1);
            this.jackhammerStack = jackhammerStack;
            this.loadContainerContents((ItemContainerContents)jackhammerStack.getOrDefault(ModDataComponents.JACKHAMMER_DRILL_BIT, (Object)ItemContainerContents.EMPTY));
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || itemStack.getItem() instanceof DrillBitItem;
        }

        public void save() {
            this.jackhammerStack.set(ModDataComponents.JACKHAMMER_DRILL_BIT, (Object)this.toContainerContents());
        }
    }

    public static class EnchantmentHandler
    extends BaseItemStackHandler {
        private final ItemStack jackhammerStack;

        public EnchantmentHandler(ItemStack jackhammerStack) {
            super(1);
            this.jackhammerStack = jackhammerStack;
            ItemEnchantments ench = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)jackhammerStack);
            for (Object2IntMap.Entry entry : ench.entrySet()) {
                if (!((Holder)entry.getKey()).is(Enchantments.SILK_TOUCH) && !((Holder)entry.getKey()).is(Enchantments.FORTUNE)) continue;
                this.setStackInSlot(0, (ItemStack)Util.make((Object)new ItemStack((ItemLike)Items.ENCHANTED_BOOK), stack -> stack.enchant((Holder)entry.getKey(), entry.getIntValue())));
                break;
            }
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.isEmpty() || EnchantmentHandler.validateBook(stack);
        }

        public void save() {
            ItemStack bookStack = this.getStackInSlot(0);
            ItemEnchantments.Mutable currentEnchants = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)this.jackhammerStack));
            currentEnchants.removeIf(h -> h.is(Enchantments.SILK_TOUCH) || h.is(Enchantments.FORTUNE));
            if (EnchantmentHandler.validateBook(bookStack)) {
                EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)bookStack).entrySet().forEach(entry -> currentEnchants.set((Holder)entry.getKey(), entry.getIntValue()));
            }
            EnchantmentHelper.setEnchantments((ItemStack)this.jackhammerStack, (ItemEnchantments)currentEnchants.toImmutable());
        }

        public static boolean validateBook(ItemStack bookStack) {
            ItemEnchantments enchantments;
            if (bookStack.getItem() == Items.ENCHANTED_BOOK && (enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)bookStack)).size() == 1) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)enchantments.entrySet().stream().findFirst().orElseThrow();
                return entry.getIntValue() > 0 && (((Holder)entry.getKey()).is(Enchantments.FORTUNE) || ((Holder)entry.getKey()).is(Enchantments.SILK_TOUCH));
            }
            return false;
        }
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            JackHammerItem jackHammer;
            Player player = event.getEntity();
            ItemStack stack = player.getItemInHand(event.getHand());
            Item item = stack.getItem();
            if (item instanceof JackHammerItem && (float)(jackHammer = (JackHammerItem)item).getAir(stack) > 0.0f) {
                if (event.getLevel().isClientSide) {
                    MovingSounds.playMovingSound(MovingSounds.Sound.JACKHAMMER, event.getEntity(), new Object[0]);
                } else {
                    NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketPlayMovingSound(MovingSounds.Sound.JACKHAMMER, PacketPlayMovingSound.MovingSoundFocus.of((Entity)player)), (Entity)player);
                }
            }
        }
    }
}

