/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PressurizableItem
extends Item
implements IPressurizableItem {
    private final int volume;
    private final float maxPressure;

    public PressurizableItem(Item.Properties props, int maxAir, int volume) {
        super(props.component(ModDataComponents.AIR, (Object)0));
        this.volume = volume;
        this.maxPressure = (float)maxAir / (float)volume;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean isBarVisible(ItemStack pStack) {
        return PressurizableItem.shouldShowPressureDurability(pStack);
    }

    public int getBarWidth(ItemStack stack) {
        return PNCCapabilities.getAirHandler(stack).map(h -> Math.round(h.getPressure() / h.maxPressure() * 13.0f)).orElse(0);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public int getBarColor(ItemStack pStack) {
        return PressurizableItem.getPressureDurabilityColor(pStack);
    }

    static int getPressureDurabilityColor(ItemStack stack) {
        return PNCCapabilities.getAirHandler(stack).map(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            int c = (int)(64.0f + 191.0f * f);
            return 0x400000 | c << 8 | 0xFF;
        }).orElse(0xC0C0C0);
    }

    static boolean shouldShowPressureDurability(ItemStack stack) {
        return PNCCapabilities.getAirHandler(stack).map(airHandler -> airHandler.getPressure() < airHandler.maxPressure()).orElse(false);
    }

    @Override
    public int getBaseVolume() {
        return this.volume;
    }

    @Override
    public int getVolumeUpgrades(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.VOLUME.get());
    }

    @Override
    public int getAir(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.AIR.get(), (Object)0);
    }

    @Override
    public float getMaxPressure() {
        return this.maxPressure;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 9;
    }
}

