/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.entity.projectile.VortexEntity;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VortexCannonItem
extends PressurizableItem {
    public VortexCannonItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> use(Level world, Player playerIn, InteractionHand handIn) {
        ItemStack iStack = playerIn.getItemInHand(handIn);
        IAirHandlerItem airHandler = PNCCapabilities.getAirHandler(iStack).orElseThrow(RuntimeException::new);
        float factor = 0.2f * airHandler.getPressure();
        if (world.isClientSide) {
            if (airHandler.getPressure() > 0.1f) {
                world.playLocalSound(playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)ModSounds.AIR_CANNON.get(), SoundSource.PLAYERS, 1.0f, 0.7f + factor * 0.2f, false);
                return InteractionResultHolder.sidedSuccess((Object)iStack, (boolean)world.isClientSide);
            }
            playerIn.playSound(SoundEvents.COMPARATOR_CLICK, 1.0f, 2.0f);
            return InteractionResultHolder.fail((Object)iStack);
        }
        if (!(airHandler.getPressure() > 0.1f)) return InteractionResultHolder.sidedSuccess((Object)iStack, (boolean)world.isClientSide);
        world.playSound(playerIn, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)ModSounds.AIR_CANNON.get(), SoundSource.PLAYERS, 1.0f, 0.7f + factor * 0.2f);
        VortexEntity vortex = (VortexEntity)ModEntityTypes.VORTEX.get().create(world);
        if (vortex == null) return InteractionResultHolder.sidedSuccess((Object)iStack, (boolean)world.isClientSide);
        Vec3 directionVec = playerIn.getLookAngle().normalize().scale(playerIn.isSprinting() ? -0.35 : -0.15);
        Vec3 vortexPos = playerIn.position().add(0.0, (double)(playerIn.getEyeHeight() / 2.0f), 0.0).add(directionVec);
        vortex.setPos(vortexPos.x, vortexPos.y, vortexPos.z);
        vortex.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f * factor, 0.0f);
        world.addFreshEntity((Entity)vortex);
        if (playerIn.isCreative()) return InteractionResultHolder.sidedSuccess((Object)iStack, (boolean)world.isClientSide);
        airHandler.addAir(-250);
        return InteractionResultHolder.sidedSuccess((Object)iStack, (boolean)world.isClientSide);
    }
}

