/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.ItemLaunching;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketChestplateLauncher(float amount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketChestplateLauncher> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("chestplate_launcher"));
    public static final StreamCodec<FriendlyByteBuf, PacketChestplateLauncher> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, PacketChestplateLauncher::amount, PacketChestplateLauncher::new);
    private static final float SCALE_FACTOR = 0.7f;

    public CustomPacketPayload.Type<PacketChestplateLauncher> type() {
        return TYPE;
    }

    public static void handle(PacketChestplateLauncher message, IPayloadContext ctx) {
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ItemStack stack = sp.getOffhandItem();
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)sp);
        if (handler.upgradeUsable(CommonUpgradeHandlers.chestplateLauncherHandler, false) && !stack.isEmpty() && !sp.getCooldowns().isOnCooldown(stack.getItem())) {
            ItemStack toFire = stack;
            if (stack.getItem() != ModItems.MICROMISSILES.get()) {
                toFire = sp.isCreative() ? stack.copyWithCount(1) : stack.split(1);
            }
            Entity launchedEntity = ItemLaunching.getEntityToLaunch(sp.getCommandSenderWorld(), toFire, sp, true, true);
            int upgrades = handler.getUpgradeCount(EquipmentSlot.CHEST, ModUpgrades.DISPENSER.get(), 4);
            Vec3 velocity = sp.getLookAngle().normalize().scale((double)(message.amount() * (float)upgrades * 0.7f));
            if (launchedEntity instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)launchedEntity;
                arrow.pickup = sp.isCreative() ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                arrow.setBaseDamage(arrow.getBaseDamage() + 0.25 * (double)upgrades * (double)message.amount());
            }
            ItemLaunching.launchEntity(launchedEntity, sp.getEyePosition(1.0f).add(0.0, -0.1, 0.0), velocity, true);
            if (!sp.isCreative()) {
                int usedAir = (int)((float)(20 * upgrades) * message.amount());
                handler.addAir(EquipmentSlot.CHEST, -usedAir);
            }
        }
    }
}

