/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record PacketSpawnParticleTrail(ParticleOptions particle, Vector3f start, Vector3f end) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSpawnParticleTrail> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("particle_trail"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSpawnParticleTrail> STREAM_CODEC = StreamCodec.composite((StreamCodec)ParticleTypes.STREAM_CODEC, PacketSpawnParticleTrail::particle, (StreamCodec)ByteBufCodecs.VECTOR3F, PacketSpawnParticleTrail::start, (StreamCodec)ByteBufCodecs.VECTOR3F, PacketSpawnParticleTrail::end, PacketSpawnParticleTrail::new);

    public CustomPacketPayload.Type<PacketSpawnParticleTrail> type() {
        return TYPE;
    }

    public static void handle(PacketSpawnParticleTrail message, IPayloadContext ctx) {
        Level level = ctx.player().level();
        int numParticles = Math.max(1, (int)message.start.distance((Vector3fc)message.end) * 25);
        for (int i = 0; i <= numParticles; ++i) {
            double pct = (double)i / (double)numParticles;
            double px = Mth.lerp((double)pct, (double)message.start.x(), (double)message.end.x());
            double py = Mth.lerp((double)pct, (double)message.start.y(), (double)message.end.y());
            double pz = Mth.lerp((double)pct, (double)message.start.z(), (double)message.end.z());
            level.addParticle(message.particle(), px + level.random.nextDouble() * 0.2 - 0.1, py + level.random.nextDouble() * 0.2 - 0.1, pz + level.random.nextDouble() * 0.2 - 0.1, 0.0, 0.0, 0.0);
        }
    }
}

