/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateGui(int syncId, Object fieldValue, SyncedField.FieldType fieldType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdateGui> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("update_gui"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateGui> STREAM_CODEC = StreamCodec.of(PacketUpdateGui::write, PacketUpdateGui::read);

    public static PacketUpdateGui create(int syncId, SyncedField<?> syncField) {
        return new PacketUpdateGui(syncId, syncField.getValue(), syncField.getFieldType());
    }

    private static PacketUpdateGui read(RegistryFriendlyByteBuf buf) {
        int syncId = buf.readVarInt();
        SyncedField.FieldType type = (SyncedField.FieldType)buf.readEnum(SyncedField.FieldType.class);
        Object value = SyncedField.fromBytes(buf, type);
        return new PacketUpdateGui(syncId, value, type);
    }

    private static void write(RegistryFriendlyByteBuf buf, PacketUpdateGui packet) {
        buf.writeVarInt(packet.syncId);
        buf.writeEnum((Enum)packet.fieldType);
        SyncedField.toBytes(buf, packet.fieldValue, packet.fieldType);
    }

    public CustomPacketPayload.Type<PacketUpdateGui> type() {
        return TYPE;
    }

    public static void handle(PacketUpdateGui message, IPayloadContext ctx) {
        ClientUtils.syncViaOpenContainerScreen(message.syncId(), message.fieldValue());
    }
}

