/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class FluidMixerRecipeImpl
extends FluidMixerRecipe {
    private final SizedFluidIngredient input1;
    private final SizedFluidIngredient input2;
    private final FluidStack outputFluid;
    private final ItemStack outputItem;
    private final float pressure;
    private final int processingTime;

    public FluidMixerRecipeImpl(SizedFluidIngredient input1, SizedFluidIngredient input2, FluidStack outputFluid, ItemStack outputItem, float pressure, int processingTime) {
        this.input1 = input1;
        this.input2 = input2;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.pressure = pressure;
        this.processingTime = processingTime;
    }

    @Override
    public boolean matches(FluidStack fluid1, FluidStack fluid2) {
        FluidIngredient ingr1 = this.input1.ingredient();
        FluidIngredient ingr2 = this.input2.ingredient();
        return ingr1.test(fluid1) && ingr2.test(fluid2) || ingr2.test(fluid1) && ingr1.test(fluid2);
    }

    @Override
    public SizedFluidIngredient getInput1() {
        return this.input1;
    }

    @Override
    public SizedFluidIngredient getInput2() {
        return this.input2;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public float getRequiredPressure() {
        return this.pressure;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.FLUID_MIXER.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.FLUID_MIXER.get();
    }

    public static class Serializer<T extends FluidMixerRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedFluidIngredient.FLAT_CODEC.fieldOf("input1").forGetter(FluidMixerRecipe::getInput1), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("input2").forGetter(FluidMixerRecipe::getInput2), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid_output").forGetter(FluidMixerRecipe::getOutputFluid), (App)ItemStack.OPTIONAL_CODEC.fieldOf("item_output").forGetter(FluidMixerRecipe::getOutputItem), (App)Codec.FLOAT.fieldOf("pressure").forGetter(FluidMixerRecipe::getRequiredPressure), (App)Codec.INT.fieldOf("time").forGetter(FluidMixerRecipe::getProcessingTime)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)SizedFluidIngredient.STREAM_CODEC, FluidMixerRecipe::getInput1, (StreamCodec)SizedFluidIngredient.STREAM_CODEC, FluidMixerRecipe::getInput2, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, FluidMixerRecipe::getOutputFluid, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, FluidMixerRecipe::getOutputItem, (StreamCodec)ByteBufCodecs.FLOAT, FluidMixerRecipe::getRequiredPressure, (StreamCodec)ByteBufCodecs.VAR_INT, FluidMixerRecipe::getProcessingTime, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends FluidMixerRecipe> {
        public T create(SizedFluidIngredient var1, SizedFluidIngredient var2, FluidStack var3, ItemStack var4, float var5, int var6);
    }
}

