/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors.entity;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.universal_sensor.IPollSensorSetting;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

abstract class EntityPollSensor
implements IPollSensorSetting {
    EntityPollSensor() {
    }

    @Override
    public Set<PNCUpgrade> getRequiredUpgrades() {
        return ImmutableSet.of((Object)ModUpgrades.ENTITY_TRACKER.get());
    }

    @Override
    public int getPollFrequency(BlockEntity te) {
        return 1;
    }

    @Override
    public int getRedstoneValue(Level level, BlockPos pos, int sensorRange, String textBoxText) {
        AABB aabb = AABB.of((BoundingBox)new BoundingBox(pos).inflatedBy(sensorRange));
        return this.getRedstoneValue(level.getEntities(EntityTypeTest.forClass(this.getEntityTracked()), aabb, Entity::isAlive), textBoxText);
    }

    protected abstract Class<? extends Entity> getEntityTracked();

    protected abstract int getRedstoneValue(List<? extends Entity> var1, String var2);
}

