/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computer_common;

import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.DroneInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ProgWidgetCC;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.entity.BlockEntity;

class DroneAICC
extends Goal {
    private final DroneEntity drone;
    private final ProgWidgetCC widget;
    private Goal curAction;
    private boolean curActionActive;
    private final DroneInterfaceBlockEntity droneInterface;
    private boolean newAction;

    DroneAICC(DroneEntity drone, ProgWidgetCC widget, boolean targetAI) {
        this.drone = drone;
        this.widget = widget;
        Set<BlockPos> area = widget.getInterfaceArea();
        for (BlockPos pos : area) {
            BlockEntity te = drone.level().getBlockEntity(pos);
            if (!(te instanceof DroneInterfaceBlockEntity)) continue;
            DroneInterfaceBlockEntity interfaceTE = (DroneInterfaceBlockEntity)te;
            if (targetAI) {
                if (interfaceTE.getDrone() != drone) continue;
                this.droneInterface = interfaceTE;
                return;
            }
            if (interfaceTE.getDrone() != null) continue;
            this.droneInterface = interfaceTE;
            this.droneInterface.setDrone(drone);
            return;
        }
        this.droneInterface = null;
    }

    public ProgWidgetCC getWidget() {
        return this.widget;
    }

    public synchronized boolean canUse() {
        this.newAction = false;
        if (this.curAction != null) {
            this.curActionActive = this.curAction.canUse();
            if (this.curActionActive) {
                this.curAction.start();
            }
        }
        return this.droneInterface != null && !this.droneInterface.isRemoved() && this.droneInterface.getDrone() == this.drone;
    }

    public synchronized boolean canContinueToUse() {
        if (!this.newAction && this.curActionActive && this.curAction != null) {
            boolean shouldContinue = this.curAction.canContinueToUse();
            if (!shouldContinue) {
                this.curAction.stop();
            }
            return shouldContinue;
        }
        return false;
    }

    public synchronized void tick() {
        if (this.curActionActive && this.curAction != null) {
            this.curAction.tick();
        }
    }

    synchronized void setAction(IProgWidget widget, Goal ai) throws IllegalArgumentException {
        this.curAction = ai;
        this.newAction = true;
        this.curActionActive = true;
    }

    synchronized void abortAction() {
        this.curAction = null;
    }

    synchronized boolean isActionDone() {
        if (this.curAction == null) {
            throw new IllegalStateException("There's no action active!");
        }
        return !this.curActionActive;
    }
}

