/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.chunkloading;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

public enum PlayerLogoutTracker {
    INSTANCE;

    private final Map<UUID, Long> LOGGED_OUT = new HashMap<UUID, Long>();

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.LOGGED_OUT.put(sp.getUUID(), System.currentTimeMillis());
        }
    }

    public long getTimeSinceLogout(@Nullable MinecraftServer server, UUID playerId) {
        if (server == null) {
            return Long.MAX_VALUE;
        }
        if (server.getPlayerList().getPlayer(playerId) != null) {
            return 0L;
        }
        Long when = this.LOGGED_OUT.get(playerId);
        return when == null ? Long.MAX_VALUE : System.currentTimeMillis() - when;
    }

    public boolean isPlayerLoggedOutTooLong(MinecraftServer server, UUID playerId) {
        long offlineTime = (long)((Integer)ConfigHelper.common().drones.chunkloadOfflineTime.get()).intValue() * 1000L;
        return offlineTime > 0L && INSTANCE.getTimeSinceLogout(server, playerId) > offlineTime;
    }
}

