/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.legacyconv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import me.desht.pneumaticcraft.common.util.legacyconv.ConversionUtil;
import me.desht.pneumaticcraft.lib.Log;

public class ActionWidgetLegacyConv {
    public static int determineVersion(JsonObject json) {
        if (json.has("version")) {
            return json.get("version").getAsInt();
        }
        if (json.has("main")) {
            return 1;
        }
        throw new JsonSyntaxException("can't determine saved remote layout version!");
    }

    public static void convertLegacy(JsonObject json, int oldVersion) {
        if (oldVersion == 1) {
            ActionWidgetLegacyConv.convertFromV1(json);
        }
    }

    private static void convertFromV1(JsonObject json) {
        JsonArray entries = json.getAsJsonObject("main").getAsJsonArray("value");
        JsonArray newDoc = new JsonArray();
        for (JsonElement entry : entries) {
            JsonObject oldEntry = entry.getAsJsonObject();
            JsonObject newEntry = new JsonObject();
            JsonObject base = new JsonObject();
            JsonObject widget = new JsonObject();
            ConversionUtil.getString(oldEntry, "enableVariable").ifPresent(val -> base.addProperty("enable_var", ConversionUtil.prefixVar(val)));
            ConversionUtil.convXYZ(oldEntry, base, "enabling", "enable_pos");
            ConversionUtil.getInt(oldEntry, "x").ifPresent(val -> widget.addProperty("x", (Number)val));
            ConversionUtil.getInt(oldEntry, "y").ifPresent(val -> widget.addProperty("y", (Number)(val + 8)));
            ConversionUtil.getInt(oldEntry, "width").ifPresent(val -> widget.addProperty("width", (Number)val));
            ConversionUtil.getInt(oldEntry, "height").ifPresent(val -> widget.addProperty("height", (Number)val));
            ConversionUtil.getString(oldEntry, "text").ifPresent(val -> widget.addProperty("title", val));
            ConversionUtil.getString(oldEntry, "tooltip").ifPresent(val -> widget.addProperty("tooltip", val));
            newEntry.add("base", (JsonElement)base);
            newEntry.add("widget", (JsonElement)widget);
            ConversionUtil.getString(oldEntry, "id").ifPresent(val -> newEntry.addProperty("type", "pneumaticcraft:" + val));
            ConversionUtil.getString(oldEntry, "variableName").ifPresent(val -> newEntry.addProperty("var_name", ConversionUtil.prefixVar(val)));
            ConversionUtil.convXYZ(oldEntry, newEntry, "setting", "set_pos");
            ConversionUtil.getString(oldEntry, "dropDownElements").ifPresent(val -> newEntry.addProperty("elements", val));
            ConversionUtil.getBool(oldEntry, "sorted").ifPresent(val -> newEntry.addProperty("sorted", val));
            newDoc.add((JsonElement)newEntry);
        }
        json.add("widgets", (JsonElement)newDoc);
        json.remove("main");
        json.addProperty("version", (Number)2);
        Log.info("Pastebin Remote import (V1 -> V2): converted {} legacy widgets", newDoc.size());
    }
}

