/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.renderers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.integration.CompatObjects;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonSpecialItemRenderer;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonSpecialItemRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class CandleHolderRendererExtension
implements IThirdPersonAnimationProvider,
IThirdPersonSpecialItemRenderer,
IFirstPersonSpecialItemRenderer {
    private static final Supplier<Map<Item, ResourceLocation>> FLAMES = Suppliers.memoize(() -> {
        Item e;
        Item c;
        HashMap<Item, ResourceLocation> map = new HashMap<Item, ResourceLocation>();
        Item s = CompatObjects.SOUL_CANDLE_ITEM.get();
        if (s != null) {
            map.put(s.asItem(), ResourceLocation.withDefaultNamespace((String)"textures/particle/soul_fire_flame.png"));
        }
        if ((c = CompatObjects.CUPRIC_CANDLE_ITEM.get()) != null) {
            map.put(c, ResourceLocation.fromNamespaceAndPath((String)"caverns_and_chasms", (String)"textures/particle/cupric_fire_flame.png"));
        }
        if ((e = CompatObjects.ENDER_CANDLE_ITEM.get()) != null) {
            map.put(e, ResourceLocation.fromNamespaceAndPath((String)"endergetic", (String)"textures/particle/ender_fire_flame.png"));
        }
        return map;
    });
    private static final ResourceLocation FLAME = ResourceLocation.withDefaultNamespace((String)"textures/particle/flame.png");

    public <T extends LivingEntity> boolean poseRightArm(ItemStack itemStack, HumanoidModel<T> model, T t, HumanoidArm arm) {
        model.rightArm.xRot = (float)(-Math.toRadians(40.0));
        return true;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack itemStack, HumanoidModel<T> model, T t, HumanoidArm arm) {
        model.leftArm.xRot = (float)(-Math.toRadians(40.0));
        return true;
    }

    public <T extends Player, M extends EntityModel<T> & HeadedModel> void renderThirdPersonItem(M parentModel, LivingEntity entity, ItemStack stack, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            ((ArmedModel)parentModel).translateToHand(humanoidArm, poseStack);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            boolean left = humanoidArm == HumanoidArm.LEFT;
            poseStack.translate((float)(left ? -1 : 1) / 16.0f, 0.125f, -0.625f);
            poseStack.scale(2.0f, 2.0f, 2.0f);
            ItemTransform transform = new ItemTransform(new Vector3f(55.0f, -180.0f, 0.0f), new Vector3f(0.0f, 2.0f, 1.25f).mul(0.0625f), new Vector3f(0.375f, 0.375f, 0.375f));
            transform.apply(left, poseStack);
            CandleHolderRendererExtension.renderLanternModel(entity, stack, poseStack, bufferSource, light, left);
            if (!entity.isInWater()) {
                CandleHolderRendererExtension.renderFlame(entity, poseStack, bufferSource, stack);
            }
            poseStack.popPose();
        }
    }

    private static void renderFlame(LivingEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, ItemStack stack) {
        VertexConsumer builder = bufferSource.getBuffer(RenderType.text((ResourceLocation)((Map)FLAMES.get()).getOrDefault(stack.getItem(), FLAME)));
        int lu = 240;
        int lv = 240;
        int b = 255;
        int g = 255;
        int r = 255;
        int a = 255;
        float period = 20.0f;
        float t = ((float)entity.tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false)) % period / period;
        float ss = 1.0f - t * t * 0.4f;
        float scale = ss * 2.0f / 16.0f;
        poseStack.translate(0.0f, 0.1875f, 0.0f);
        poseStack.last().pose().setRotationXYZ(0.0f, 0.0f, 0.0f);
        poseStack.scale(-scale, scale, -scale);
        VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)-0.5f, (float)-0.5f, (float)0.5f, (float)0.5f, (int)r, (int)g, (int)b, (int)a, (int)lu, (int)lv);
    }

    private static void renderLanternModel(LivingEntity entity, ItemStack itemStack, PoseStack poseStack, MultiBufferSource buffer, int light, boolean left) {
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        BlockState state = ((BlockItem)itemStack.getItem()).getBlock().defaultBlockState();
        if (!entity.isInWater()) {
            state = (BlockState)state.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
        }
        BakedModel model = mc.getBlockRenderer().getBlockModel(state);
        itemRenderer.render(itemStack, ItemDisplayContext.NONE, left, poseStack, buffer, light, OverlayTexture.NO_OVERLAY, model);
    }

    public boolean renderFirstPersonItem(AbstractClientPlayer player, ItemStack stack, InteractionHand interactionHand, HumanoidArm arm, PoseStack poseStack, float partialTicks, float pitch, float attackAnim, float equipAnim, MultiBufferSource buffer, int light, ItemInHandRenderer renderer) {
        boolean left = arm == HumanoidArm.LEFT;
        float f = left ? -1.0f : 1.0f;
        poseStack.pushPose();
        float n = -0.4f * Mth.sin((float)(Mth.sqrt((float)attackAnim) * (float)Math.PI));
        float m = 0.2f * Mth.sin((float)(Mth.sqrt((float)attackAnim) * ((float)Math.PI * 2)));
        float h = -0.2f * Mth.sin((float)(attackAnim * (float)Math.PI));
        poseStack.translate(f * n, m, h);
        renderer.applyItemArmTransform(poseStack, arm, equipAnim);
        renderer.applyItemArmAttackTransform(poseStack, arm, attackAnim);
        poseStack.translate(0.0, 0.3125, 0.0);
        float scale = (float)ClientConfigs.CANDLE_HOLDING_SIZE.get().doubleValue();
        poseStack.scale(-scale, scale, -scale);
        CandleHolderRendererExtension.renderLanternModel((LivingEntity)player, stack, poseStack, buffer, light, left);
        if (!player.isInWater()) {
            poseStack.translate((double)f * 0.03, 0.0, (double)-0.04f);
            CandleHolderRendererExtension.renderFlame((LivingEntity)player, poseStack, buffer, stack);
        }
        poseStack.popPose();
        return true;
    }
}

