/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StructureCauldronHack
extends Block
implements EntityBlock {
    private static final Supplier<StructureCauldronHack> BLOCK = RegHelper.registerBlock((ResourceLocation)Amendments.res("cauldron_hack"), StructureCauldronHack::new);
    private static final Supplier<BlockEntityType<Tile>> TILE = RegHelper.registerBlockEntityType((ResourceLocation)Amendments.res("cauldron_hack"), () -> PlatHelper.newBlockEntityType(Tile::new, (Block[])new Block[]{BLOCK.get()}));
    private static final BooleanProperty POTION = BooleanProperty.create((String)"potion");
    private static final Supplier<List<Potion>> HARMFUL_POTS = Suppliers.memoize(() -> BuiltInRegistries.POTION.stream().filter(p -> p.getEffects().stream().noneMatch(e -> ((MobEffect)e.getEffect().value()).isBeneficial())).toList());

    public static void register() {
    }

    public StructureCauldronHack() {
        super(BlockBehaviour.Properties.of().dropsLike(Blocks.CAULDRON));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POTION});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new Tile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, TILE.get(), Tile::tick);
    }

    private static class Tile
    extends BlockEntity {
        public Tile(BlockPos pos, BlockState blockState) {
            super(TILE.get(), pos, blockState);
        }

        public static <E extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, E e) {
            level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
            if (((Boolean)state.getValue((Property)POTION)).booleanValue()) {
                level.setBlockAndUpdate(pos, ModRegistry.LIQUID_CAULDRON.get().defaultBlockState());
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                    List<Potion> list = HARMFUL_POTS.get();
                    Potion pot = list.get(level.random.nextInt(list.size()));
                    SoftFluidStack fluidStack = SoftFluidStack.of((Holder)BuiltInSoftFluids.POTION, (int)level.random.nextIntBetweenInclusive(1, 4));
                    fluidStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(BuiltInRegistries.POTION.wrapAsHolder((Object)pot)));
                    if ((double)level.random.nextFloat() < 0.4) {
                        fluidStack.set((DataComponentType)MoonlightRegistry.BOTTLE_TYPE.get(), (Object)PotionBottleType.SPLASH);
                    }
                    te.getSoftFluidTank().setFluid(fluidStack);
                    te.setChanged();
                }
            } else {
                level.setBlockAndUpdate(pos, ModRegistry.DYE_CAULDRON.get().defaultBlockState());
                BlockEntity list = level.getBlockEntity(pos);
                if (list instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)list;
                    DyeColor dye = DyeColor.byId((int)level.random.nextInt(DyeColor.values().length));
                    SoftFluidStack fluid = DyeBottleItem.createFluidStack(dye, 3);
                    te.getSoftFluidTank().setFluid(fluid);
                    te.setChanged();
                }
            }
        }
    }
}

