/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class CauldronDyeWater
implements BlockUse {
    @Override
    public boolean isEnabled() {
        return CommonConfigs.DYE_WATER.get();
    }

    @Override
    public boolean appliesToBlock(Block block) {
        return Blocks.WATER_CAULDRON == block;
    }

    @Override
    public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        Item item;
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (state.is(Blocks.WATER_CAULDRON) && (item = stack.getItem()) instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            Integer l = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
            level.setBlockAndUpdate(pos, (BlockState)ModRegistry.DYE_CAULDRON.get().defaultBlockState().setValue((Property)DyeCauldronBlock.LEVEL, (Comparable)l));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                te.getSoftFluidTank().setFluid(DyeBottleItem.createFluidStack(dye.getDyeColor(), l));
            }
            DyeCauldronBlock.playDyeSoundAndConsume(state, pos, level, player, stack);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

