/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toni.sodiumdynamiclights.DynamicLightSource;
import toni.sodiumdynamiclights.DynamicLightsMode;
import toni.sodiumdynamiclights.SodiumDynamicLights;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Final
    @Shadow
    protected BlockPos worldPosition;
    @Shadow
    @Nullable
    protected Level level;
    @Shadow
    protected boolean remove;
    @Unique
    private int luminance = 0;
    @Unique
    private int lastLuminance = 0;
    @Unique
    private long lastUpdate = 0L;
    @Unique
    private final LongOpenHashSet sodiumdynamiclights$trackedLitChunkPos = new LongOpenHashSet();

    @Override
    public double sdl$getDynamicLightX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double sdl$getDynamicLightY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double sdl$getDynamicLightZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    @Override
    public Level sdl$getDynamicLightLevel() {
        return this.level;
    }

    @Inject(method={"setRemoved()V"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.sdl$setDynamicLightEnabled(false);
    }

    @Override
    public void sdl$resetDynamicLight() {
        this.lastLuminance = 0;
    }

    @Override
    public void sdl$dynamicLightTick() {
        if (this.level == null || !this.level.isClientSide()) {
            return;
        }
        if (!this.remove) {
            this.luminance = DynamicLightHandlers.getLuminanceFrom((BlockEntity)this);
            SodiumDynamicLights.updateTracking(this);
            if (!this.sdl$isDynamicLightEnabled()) {
                this.lastLuminance = 0;
            }
        }
    }

    @Override
    public int sdl$getLuminance() {
        return this.luminance;
    }

    @Override
    public boolean sdl$shouldUpdateDynamicLight() {
        DynamicLightsMode mode = SodiumDynamicLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public boolean sodiumdynamiclights$updateDynamicLight(@NotNull LevelRenderer renderer) {
        if (!this.sdl$shouldUpdateDynamicLight()) {
            return false;
        }
        int luminance = this.sdl$getLuminance();
        if (luminance != this.lastLuminance) {
            this.lastLuminance = luminance;
            if (this.sodiumdynamiclights$trackedLitChunkPos.isEmpty()) {
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(Math.floorDiv(this.worldPosition.getX(), 16), Mth.floorDiv((int)this.worldPosition.getY(), (int)16), Mth.floorDiv((int)this.worldPosition.getZ(), (int)16));
                SodiumDynamicLights.updateTrackedChunks((BlockPos)chunkPos, null, this.sodiumdynamiclights$trackedLitChunkPos);
                Direction directionX = (this.worldPosition.getX() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (this.worldPosition.getY() & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.worldPosition.getZ() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.move(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.move(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.move(directionX.getOpposite());
                    } else {
                        chunkPos.move(directionZ.getOpposite());
                        chunkPos.move(directionY);
                    }
                    SodiumDynamicLights.updateTrackedChunks((BlockPos)chunkPos, null, this.sodiumdynamiclights$trackedLitChunkPos);
                }
            }
            this.sodiumdynamiclights$scheduleTrackedChunksRebuild(renderer);
            return true;
        }
        return false;
    }

    @Override
    public void sodiumdynamiclights$scheduleTrackedChunksRebuild(@NotNull LevelRenderer renderer) {
        if (this.level == Minecraft.getInstance().level) {
            LongIterator longIterator = this.sodiumdynamiclights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                SodiumDynamicLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

