/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;

@FieldsNullabilityUnknownByDefault
public class PrintingRecipeParams
extends ProcessingRecipeParams {
    protected static final Codec<PlaySoundEffect> SOUND_CODEC = Codec.either((Codec)BuiltInRegistries.SOUND_EVENT.holderByNameCodec(), (Codec)PlaySoundEffect.CODEC.codec()).xmap(either -> (PlaySoundEffect)either.map(sound -> new PlaySoundEffect(sound, (FloatProvider)ConstantFloat.of((float)1.0f), (FloatProvider)ConstantFloat.of((float)1.0f)), Function.identity()), Either::right);
    protected static final StreamCodec<ByteBuf, PlaySoundEffect> SOUND_STREAM_CODEC = ByteBufCodecs.fromCodec(SOUND_CODEC);
    public static final MapCodec<PrintingRecipeParams> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PrintingRecipeParams.codec(PrintingRecipeParams::new).forGetter(Function.identity()), (App)SOUND_CODEC.fieldOf("sound").forGetter(PrintingRecipeParams::getSound)).apply((Applicative)instance, PrintingRecipeParams::setSound)).validate(PrintingRecipeParams::validate);
    public static final StreamCodec<RegistryFriendlyByteBuf, PrintingRecipeParams> STREAM_CODEC = PrintingRecipeParams.streamCodec(PrintingRecipeParams::new);
    protected PlaySoundEffect sound;

    protected PrintingRecipeParams() {
    }

    public PrintingRecipeParams(PlaySoundEffect sound) {
        this.sound = sound;
    }

    protected PlaySoundEffect getSound() {
        return this.sound;
    }

    protected PrintingRecipeParams setSound(PlaySoundEffect sound) {
        this.sound = sound;
        return this;
    }

    protected DataResult<PrintingRecipeParams> validate() {
        if (this.ingredients.size() != 2) {
            return DataResult.error(() -> "Printing recipe must have 2 item inputs, [0]: input, [1]: template");
        }
        if (this.fluidIngredients.size() != 1) {
            return DataResult.error(() -> "Printing recipe must have 1 fluid input");
        }
        return DataResult.success((Object)((Object)this));
    }

    protected void encode(RegistryFriendlyByteBuf buffer) {
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode((Object)buffer, (Object)this.ingredients);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).encode((Object)buffer, (Object)this.results);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidIngredient.STREAM_CODEC).encode((Object)buffer, (Object)this.fluidIngredients);
        SOUND_STREAM_CODEC.encode((Object)buffer, (Object)this.sound);
    }

    protected void decode(RegistryFriendlyByteBuf buffer) {
        this.ingredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode((Object)buffer);
        this.results = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).decode((Object)buffer);
        this.fluidIngredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidIngredient.STREAM_CODEC).decode((Object)buffer);
        this.sound = (PlaySoundEffect)SOUND_STREAM_CODEC.decode((Object)buffer);
    }
}

