/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.enchanter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

public class CEIEnchantmentHelper {
    @Nullable
    public static Function<Holder<Enchantment>, Integer> alternativeMaxLevel;

    public static int getEnchantmentCost(Holder<Enchantment> holder, int level) {
        Enchantment enchantment = (Enchantment)holder.value();
        int cost = ExperienceHelper.getExperienceForNextLevel(enchantment.getMinCost(level));
        if (level == 1) {
            return cost;
        }
        return cost + CEIEnchantmentHelper.getEnchantmentCost(holder, level - 1);
    }

    public static int getEnchantmentCost(ItemEnchantments enchantments) {
        return enchantments.entrySet().stream().mapToInt(entry -> CEIEnchantmentHelper.getEnchantmentCost((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue())).sum();
    }

    public static int getAdjustedLevel(ItemStack stack, int level) {
        int value = stack.getEnchantmentValue();
        if (value > 0) {
            level += 1 + value / 4;
        }
        float f = 0.15f;
        level = Mth.clamp((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE);
        return level;
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int level, Stream<Holder<Enchantment>> possibleEnchantments, boolean special) {
        ArrayList list = Lists.newArrayList();
        possibleEnchantments.forEach(holder -> {
            int maxLevel;
            Enchantment enchantment = (Enchantment)holder.value();
            for (int i = maxLevel = CEIEnchantmentHelper.maxLevel((Holder<Enchantment>)holder); i >= enchantment.getMinLevel(); --i) {
                if (level < enchantment.getMinCost(i) || level > enchantment.getMaxCost(i)) continue;
                list.add(new EnchantmentInstance(holder, i));
                break;
            }
        });
        return list;
    }

    public static List<EnchantmentInstance> selectEnchantments(RandomSource random, int adjustedLevel, List<EnchantmentInstance> available, boolean special) {
        ArrayList list = Lists.newArrayList();
        WeightedRandom.getRandomItem((RandomSource)random, available).ifPresent(list::add);
        while (random.nextInt(50) <= adjustedLevel) {
            if (!list.isEmpty()) {
                if (special && ((Boolean)CEIConfig.enchantments().ignoreEnchantmentCompatibility.get()).booleanValue()) {
                    available.removeIf(instance -> instance.enchantment.equals((Object)((EnchantmentInstance)list.getLast()).enchantment));
                } else {
                    EnchantmentHelper.filterCompatibleEnchantments(available, (EnchantmentInstance)((EnchantmentInstance)list.getLast()));
                }
            }
            if (available.isEmpty()) break;
            WeightedRandom.getRandomItem((RandomSource)random, available).ifPresent(list::add);
            adjustedLevel /= 2;
        }
        return list;
    }

    public static int maxLevel(Holder<Enchantment> enchantment) {
        if (alternativeMaxLevel == null) {
            return ((Enchantment)enchantment.value()).getMaxLevel();
        }
        return alternativeMaxLevel.apply(enchantment);
    }

    public static int levelExtension(Holder<Enchantment> enchantment) {
        Integer result = (Integer)enchantment.getData(CEIDataMaps.SUPER_ENCHANTING_LEVEL_EXTENSION);
        return result != null ? result.intValue() : ((Integer)CEIConfig.enchantments().enchantmentMaxLevelExtension.get()).intValue();
    }
}

