/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.forger;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.CEIEnchantmentHelper;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.EnchantingTemplateItem;
import plus.dragons.createenchantmentindustry.common.processing.forger.BlazeForgerBlockEntity;
import plus.dragons.createenchantmentindustry.common.registry.CEIAdvancements;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.common.registry.CEIItems;
import plus.dragons.createenchantmentindustry.common.registry.CEIStats;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

public class BlazeForgerInventory
extends ItemStackHandler {
    private final BlazeForgerBlockEntity forger;
    private int cost;
    private int mode;
    private boolean conflicting;
    private boolean overCap;

    public BlazeForgerInventory(BlazeForgerBlockEntity forger) {
        super(6);
        this.forger = forger;
        this.mode = 0;
        this.conflicting = false;
        this.overCap = false;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public int getSlots() {
        return 4;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot > 1) {
            return stack;
        }
        if (!((ItemStack)this.stacks.get(2)).isEmpty() || !((ItemStack)this.stacks.get(3)).isEmpty()) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    protected void onLoad() {
        Level level = this.forger.getLevel();
        if (level != null && !level.isClientSide) {
            this.updateResult();
        }
    }

    protected void onContentsChanged(int slot) {
        if (slot == 0 || slot == 1) {
            this.updateResult();
        }
        this.forger.notifyUpdate();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.cost = nbt.getInt("Cost");
        this.mode = nbt.getInt("Mode");
        this.conflicting = nbt.getBoolean("Conflicting");
        this.overCap = nbt.getBoolean("OverCap");
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        nbt.putInt("Cost", this.cost);
        nbt.putInt("Mode", this.mode);
        nbt.putBoolean("Conflicting", this.conflicting);
        nbt.putBoolean("OverCap", this.overCap);
        return nbt;
    }

    public boolean hasRemainingOutput() {
        return !((ItemStack)this.stacks.get(2)).isEmpty() || !((ItemStack)this.stacks.get(3)).isEmpty();
    }

    protected int getExperienceCost() {
        return this.cost == 0 ? 0 : ExperienceHelper.getExperienceForTotalLevel(this.cost);
    }

    protected ItemStack extractInput(int slot, boolean simulate) {
        this.validateSlotIndex(slot);
        ItemStack stack = (ItemStack)this.stacks.get(slot);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return stack.copy();
    }

    protected ItemStack getResult(int slot) {
        if (slot < 0 || slot >= 2) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0,2)");
        }
        return (ItemStack)this.stacks.get(slot + 4);
    }

    protected void clearInput() {
        this.stacks.set(0, (Object)ItemStack.EMPTY);
        this.stacks.set(1, (Object)ItemStack.EMPTY);
        this.cost = 0;
    }

    protected void applyResult() {
        this.stacks.set(2, (Object)((ItemStack)this.stacks.get(4)).copy());
        this.stacks.set(3, (Object)((ItemStack)this.stacks.get(5)).copy());
        this.clearInput();
        this.forger.advancement.awardStat((ResourceLocation)CEIStats.FORGE.get(), 1);
        if (this.forger.special) {
            this.forger.advancement.awardStat((ResourceLocation)CEIStats.SUPER_ENCHANT.get(), 1);
            if (this.overCap) {
                this.forger.advancement.trigger(CEIAdvancements.TRANSCENDENT_OVERCLOCK.builtinTrigger());
            }
            if (this.conflicting) {
                this.forger.advancement.trigger(CEIAdvancements.PARADOX_FUSION.builtinTrigger());
            }
        }
        this.forger.advancement.trigger(this.mode == 0 ? CEIAdvancements.BLAZING_FUSION.builtinTrigger() : (this.mode == 1 ? CEIAdvancements.SIGIL_CASTING.builtinTrigger() : CEIAdvancements.MAGIC_UNBINDING.builtinTrigger()));
        this.forger.advancement.awardStat((ResourceLocation)CEIStats.FORGE.get(), 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateResult() {
        Item baseTemplate2;
        ItemStack base = ((ItemStack)this.stacks.get(0)).copy();
        ItemStack addition = ((ItemStack)this.stacks.get(1)).copy();
        this.stacks.set(4, (Object)base);
        this.stacks.set(5, (Object)addition);
        if (base.isEmpty() || addition.isEmpty()) {
            this.cost = 0;
            return;
        }
        DataComponentType baseType = EnchantmentHelper.getComponentType((ItemStack)base);
        ItemEnchantments baseEnchantments = (ItemEnchantments)base.getOrDefault(baseType, (Object)ItemEnchantments.EMPTY);
        DataComponentType additionType = EnchantmentHelper.getComponentType((ItemStack)addition);
        ItemEnchantments additionEnchantments = (ItemEnchantments)addition.getOrDefault(additionType, (Object)ItemEnchantments.EMPTY);
        this.mode = 0;
        this.conflicting = false;
        this.overCap = false;
        if (baseType == DataComponents.STORED_ENCHANTMENTS) {
            Item item = base.getItem();
            if (item instanceof EnchantingTemplateItem) {
                EnchantingTemplateItem baseTemplate2 = (EnchantingTemplateItem)item;
                Item item2 = addition.getItem();
                if (item2 instanceof EnchantingTemplateItem) {
                    EnchantingTemplateItem addTemplate = (EnchantingTemplateItem)item2;
                    if (!(!this.forger.special || baseTemplate2.isSpecial() && addTemplate.isSpecial())) {
                        return;
                    }
                    if (additionEnchantments.isEmpty()) {
                        if (!this.splitEnchantments(base, addition, baseEnchantments, additionEnchantments)) {
                            return;
                        }
                    } else {
                        if (!this.combineEnchantments(base, addition, baseEnchantments, additionEnchantments)) return;
                        this.stacks.set(5, (Object)ItemStack.EMPTY);
                    }
                }
            } else if (base.is(Items.ENCHANTED_BOOK)) {
                Item item3 = addition.getItem();
                if (item3 instanceof EnchantingTemplateItem) {
                    EnchantingTemplateItem template = (EnchantingTemplateItem)item3;
                    if (this.forger.special && !template.isSpecial()) {
                        return;
                    }
                    if (additionEnchantments.isEmpty()) {
                        if (baseEnchantments.size() == 1) {
                            ItemStack book = Items.BOOK.getDefaultInstance();
                            EnchantmentHelper.setEnchantments((ItemStack)addition, (ItemEnchantments)baseEnchantments);
                            this.stacks.set(4, (Object)book);
                            this.stacks.set(5, (Object)addition);
                            Object2IntMap.Entry enchantment = (Object2IntMap.Entry)baseEnchantments.entrySet().stream().findFirst().get();
                            this.cost += Math.max(1, ((Enchantment)((Holder)enchantment.getKey()).value()).getAnvilCost() * 2) * enchantment.getIntValue();
                        } else if (!this.splitEnchantments(base, addition, baseEnchantments, additionEnchantments)) {
                            return;
                        }
                    } else {
                        if (!this.applyEnchantments(base, baseEnchantments, additionEnchantments)) return;
                        this.stacks.set(5, (Object)ItemStack.EMPTY);
                    }
                } else {
                    if (!addition.is(Items.ENCHANTED_BOOK)) return;
                    if (!this.combineEnchantments(base, addition, baseEnchantments, additionEnchantments)) return;
                    this.stacks.set(5, (Object)ItemStack.EMPTY);
                }
            }
        } else if (base.is(Items.BOOK) && (baseTemplate2 = addition.getItem()) instanceof EnchantingTemplateItem) {
            EnchantingTemplateItem template = (EnchantingTemplateItem)baseTemplate2;
            if (this.forger.special && !template.isSpecial()) {
                return;
            }
            if (additionEnchantments.isEmpty()) {
                return;
            }
            if (!this.applyEnchantmentsToBook(base, additionEnchantments)) return;
            this.stacks.set(5, (Object)ItemStack.EMPTY);
        } else {
            Item item = addition.getItem();
            if (item instanceof EnchantingTemplateItem) {
                EnchantingTemplateItem template = (EnchantingTemplateItem)item;
                if (this.forger.special && !template.isSpecial()) {
                    return;
                }
                if (additionEnchantments.isEmpty()) {
                    if (baseEnchantments.isEmpty()) {
                        return;
                    }
                    if (!this.splitEnchantments(base, addition, baseEnchantments, additionEnchantments)) {
                        return;
                    }
                } else {
                    if (!this.applyEnchantments(base, baseEnchantments, additionEnchantments)) return;
                    this.stacks.set(5, (Object)ItemStack.EMPTY);
                }
            } else if (addition.is(Items.ENCHANTED_BOOK)) {
                if (!this.applyEnchantments(base, baseEnchantments, additionEnchantments)) return;
                this.stacks.set(5, (Object)ItemStack.EMPTY);
            } else {
                if (!ItemStack.isSameItem((ItemStack)base, (ItemStack)addition)) return;
                if (!this.combineEnchantments(base, addition, baseEnchantments, additionEnchantments)) return;
                this.stacks.set(5, (Object)ItemStack.EMPTY);
            }
        }
        this.applyRepairCost(base, addition);
    }

    protected boolean splitEnchantments(ItemStack base, ItemStack addition, ItemEnchantments baseEnchantments, ItemEnchantments additionEnchantments) {
        Optional<Holder> optional;
        this.mode = 2;
        if (baseEnchantments.isEmpty()) {
            return false;
        }
        Registry registry = Objects.requireNonNull(this.forger.getLevel()).registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Stream<Holder> stream = baseEnchantments.keySet().stream().sorted(Comparator.comparingInt(holder -> registry.getId((Object)((Enchantment)holder.value()))));
        if (!this.forger.special) {
            stream = stream.filter(holder -> !holder.is(EnchantmentTags.CURSE));
        }
        if ((optional = stream.findFirst()).isEmpty()) {
            return false;
        }
        Holder enchantment = optional.get();
        ItemEnchantments.Mutable removedEnchantments = new ItemEnchantments.Mutable(baseEnchantments);
        removedEnchantments.set(enchantment, 0);
        EnchantmentHelper.setEnchantments((ItemStack)base, (ItemEnchantments)removedEnchantments.toImmutable());
        int level = baseEnchantments.getLevel(enchantment);
        if (!this.forger.special) {
            level = Math.min(level, CEIEnchantmentHelper.maxLevel((Holder<Enchantment>)enchantment) + ((Boolean)CEIConfig.enchantments().splitEnchantmentRespectLevelExtension.get() != false ? CEIEnchantmentHelper.levelExtension((Holder<Enchantment>)enchantment) : 0));
        }
        addition.enchant(enchantment, level);
        Float multiplier = (Float)enchantment.getData(CEIDataMaps.SPLITTING_COST_MULTIPLIER);
        this.cost += (int)((float)(Math.max(1, ((Enchantment)enchantment.value()).getAnvilCost() * 2) * level) * (multiplier != null ? multiplier.floatValue() : 1.0f));
        return true;
    }

    protected boolean applyEnchantments(ItemStack base, ItemEnchantments baseEnchantments, ItemEnchantments additionEnchantments) {
        this.mode = 1;
        int cost = 0;
        ItemEnchantments.Mutable resultEnchantments = new ItemEnchantments.Mutable(baseEnchantments);
        boolean applied = false;
        for (Object2IntMap.Entry entry : additionEnchantments.entrySet()) {
            int additionLevel;
            Holder holder = (Holder)entry.getKey();
            int baseLevel = resultEnchantments.getLevel(holder);
            int resultLevel = baseLevel == (additionLevel = entry.getIntValue()) ? additionLevel + 1 : Math.max(additionLevel, baseLevel);
            Enchantment enchantment = (Enchantment)holder.value();
            boolean applicable = base.supportsEnchantment(holder);
            for (Holder holder1 : resultEnchantments.keySet()) {
                if (holder1.equals((Object)holder) || Enchantment.areCompatible((Holder)holder, (Holder)holder1)) continue;
                applicable = this.forger.special && (Boolean)CEIConfig.enchantments().ignoreEnchantmentCompatibility.get() != false;
                this.conflicting = true;
                ++cost;
            }
            if (!applicable) continue;
            applied = true;
            int maxLevel = CEIEnchantmentHelper.maxLevel((Holder<Enchantment>)holder);
            int extendedMaxLevel = maxLevel + CEIEnchantmentHelper.levelExtension((Holder<Enchantment>)holder);
            if (resultLevel > extendedMaxLevel) {
                resultLevel = extendedMaxLevel;
            } else if (resultLevel > maxLevel && !this.forger.special) {
                resultLevel = maxLevel;
            }
            if (resultLevel > maxLevel) {
                this.overCap = true;
            }
            resultEnchantments.set(holder, resultLevel);
            int anvilCost = enchantment.getAnvilCost();
            anvilCost = Math.max(1, anvilCost / 2);
            Float multiplier = (Float)holder.getData(CEIDataMaps.FORGING_COST_MULTIPLIER);
            cost += (int)((float)(anvilCost * resultLevel) * (multiplier != null ? multiplier.floatValue() : 1.0f));
        }
        if (!applied) {
            return false;
        }
        EnchantmentHelper.setEnchantments((ItemStack)base, (ItemEnchantments)resultEnchantments.toImmutable());
        this.cost += cost;
        return true;
    }

    protected boolean applyEnchantmentsToBook(ItemStack base, ItemEnchantments additionEnchantments) {
        this.mode = 1;
        int cost = 0;
        ItemEnchantments.Mutable resultEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        boolean applied = false;
        for (Object2IntMap.Entry entry : additionEnchantments.entrySet()) {
            Holder holder = (Holder)entry.getKey();
            Enchantment enchantment = (Enchantment)holder.value();
            boolean applicable = true;
            for (Holder holder1 : resultEnchantments.keySet()) {
                if (holder1.equals((Object)holder) || Enchantment.areCompatible((Holder)holder, (Holder)holder1)) continue;
                this.conflicting = applicable = this.forger.special && (Boolean)CEIConfig.enchantments().ignoreEnchantmentCompatibility.get() != false;
                ++cost;
            }
            if (!applicable) continue;
            applied = true;
            resultEnchantments.set(holder, entry.getIntValue());
            int anvilCost = enchantment.getAnvilCost();
            anvilCost = Math.max(1, anvilCost / 2);
            Float multiplier = (Float)holder.getData(CEIDataMaps.FORGING_COST_MULTIPLIER);
            cost += (int)((float)(anvilCost * entry.getIntValue()) * (multiplier != null ? multiplier.floatValue() : 1.0f));
        }
        if (!applied) {
            return false;
        }
        base = Items.ENCHANTED_BOOK.getDefaultInstance();
        EnchantmentHelper.setEnchantments((ItemStack)base, (ItemEnchantments)resultEnchantments.toImmutable());
        this.stacks.set(4, (Object)base);
        this.cost += cost;
        return true;
    }

    protected boolean combineEnchantments(ItemStack base, ItemStack addition, ItemEnchantments baseEnchantments, ItemEnchantments additionEnchantments) {
        boolean applied = false;
        if (base.isDamaged()) {
            int baseDurability = base.getMaxDamage() - base.getDamageValue();
            int additionDurability = addition.getMaxDamage() - addition.getDamageValue();
            int fix = additionDurability + base.getMaxDamage() * 12 / 100;
            int resultDurability = baseDurability + fix;
            int resultDamage = base.getMaxDamage() - resultDurability;
            if (resultDamage < 0) {
                resultDamage = 0;
            }
            if (resultDamage < base.getDamageValue()) {
                base.setDamageValue(resultDamage);
                this.cost += 2;
                applied = true;
            }
        }
        this.mode = 0;
        return applied |= this.applyEnchantments(base, baseEnchantments, additionEnchantments);
    }

    protected void applyRepairCost(ItemStack base, ItemStack addition) {
        if (!this.forger.cursed) {
            return;
        }
        int baseCost = (Integer)base.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
        int additionCost = (Integer)addition.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
        int resultCost = AnvilMenu.calculateIncreasedRepairCost((int)Math.max(baseCost, additionCost));
        base.set(DataComponents.REPAIR_COST, (Object)resultCost);
    }

    boolean forgingCompleted() {
        return !((ItemStack)this.stacks.get(2)).isEmpty() && this.forger.processingTime == -1;
    }

    boolean notEnoughItemToForge() {
        return ((ItemStack)this.stacks.get(0)).isEmpty() || ((ItemStack)this.stacks.get(1)).isEmpty();
    }

    boolean incompatibleEnchantingTemplateType() {
        ItemStack base = (ItemStack)this.stacks.get(0);
        ItemStack addition = (ItemStack)this.stacks.get(1);
        if (!this.forger.special && (base.is(CEIItems.SUPER_ENCHANTING_TEMPLATE) || addition.is(CEIItems.SUPER_ENCHANTING_TEMPLATE))) {
            return true;
        }
        return this.forger.special && (base.is(CEIItems.ENCHANTING_TEMPLATE) || addition.is(CEIItems.ENCHANTING_TEMPLATE));
    }
}

