/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.registry;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.simibubi.create.content.logistics.item.filter.attribute.SingletonItemAttribute;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.GrindstoneHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;

public class CEIItemAttributes {
    private static final DeferredRegister<ItemAttributeType> ITEM_ATTRIBUTES = DeferredRegister.create((ResourceKey)CreateRegistries.ITEM_ATTRIBUTE_TYPE, (String)"create_enchantment_industry");
    public static final Holder<ItemAttributeType> PROCESSABLE_BY_MECHANICAL_GRINDSTONE = CEIItemAttributes.attribute("processable_by_mechanical_grindstone", "can be processed by Mechanical Grindstone", "cannot be processed by Mechanical Grindstone", (itemStack, level) -> {
        SingleRecipeInput input = new SingleRecipeInput(itemStack);
        RecipeManager recipeManager = level.getRecipeManager();
        Optional grinding = recipeManager.getRecipeFor(CEIRecipes.GRINDING.getType(), (RecipeInput)input, level);
        if (grinding.isPresent()) {
            return true;
        }
        if (recipeManager.getRecipeFor(AllRecipeTypes.SANDPAPER_POLISHING.getType(), (RecipeInput)input, level).isPresent()) {
            return true;
        }
        return GrindstoneHelper.canItemBeGrinded(itemStack, ItemStack.EMPTY);
    });

    private static Holder<ItemAttributeType> attribute(String name, String description, String invertedDescription, BiPredicate<ItemStack, Level> predicate) {
        String descriptionKey = "create.item_attributes.create_enchantment_industry." + name;
        String invertedDescriptionKey = descriptionKey + ".inverted";
        CEICommon.REGISTRATE.addRawLang(descriptionKey, description);
        CEICommon.REGISTRATE.addRawLang(invertedDescriptionKey, invertedDescription);
        return ITEM_ATTRIBUTES.register(name, () -> new SingletonItemAttribute.Type(type -> new SingletonItemAttribute(type, predicate, "create_dragons_plus." + name)));
    }

    public static void register(IEventBus modBus) {
        ITEM_ATTRIBUTES.register(modBus);
    }
}

