/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.bracelet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

public class WitheredBraceletItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"passive").maxLevel(0).build()).ability(AbilityData.builder((String)"withered").stat(StatData.builder((String)"chance").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"time").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 11, 27).star(1, 11, 18).star(2, 6, 22).star(3, 16, 21).star(4, 11, 14).star(5, 11, 9).star(6, 6, 12).star(7, 7, 7).star(8, 16, 9).star(9, 13, 6).link(0, 1).link(1, 2).link(1, 3).link(1, 4).link(4, 5).link(5, 6).link(5, 7).link(5, 8).link(5, 9).link(7, 9).link(9, 8).link(4, 8).link(4, 6).link(6, 7).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-11385539).borderBottom(-13752801).build()).beams(BeamsData.builder().startColor(-10140106).endColor(4009253).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"withered").initialValue(1).gem(GemShape.SQUARE, GemColor.YELLOW).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.NETHER_LIKE, LootEntries.THE_NETHER}).build()).build();
    }

    @EventBusSubscriber
    public static class WitheredBraceletEvent {
        @SubscribeEvent
        public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
            WitheredBraceletItem relic;
            Player player;
            block5: {
                block4: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block4;
                    player = (Player)livingEntity;
                    if (event.getSource().is(DamageTypes.WITHER)) break block5;
                }
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.WITHERED_BRACELET.value()));
            Item item = stack.getItem();
            if (!(item instanceof WitheredBraceletItem) || !(relic = (WitheredBraceletItem)item).canPlayerUseAbility(player, stack, "passive")) {
                return;
            }
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onReceivingDamage(AttackEntityEvent event) {
            WitheredBraceletItem relic;
            ItemStack stack;
            LivingEntity attacker;
            Level level;
            Player player;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            player = event.getEntity();
                            level = player.getCommandSenderWorld();
                            Entity entity = event.getTarget();
                            if (!(entity instanceof LivingEntity)) break block4;
                            attacker = (LivingEntity)entity;
                            if (!level.isClientSide() && !attacker.getStringUUID().equals(player.getStringUUID())) break block5;
                        }
                        return;
                    }
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.WITHERED_BRACELET.value()));
                    RandomSource random = player.getRandom();
                    Item item = stack.getItem();
                    if (!(item instanceof WitheredBraceletItem)) break block6;
                    relic = (WitheredBraceletItem)item;
                    if (!(random.nextDouble() > relic.getStatValue(stack, "withered", "chance")) && relic.isAbilityUnlocked(stack, "withered")) break block7;
                }
                return;
            }
            attacker.addEffect(new MobEffectInstance(MobEffects.WITHER, (int)relic.getStatValue(stack, "withered", "time") * 20, 1));
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(75, 0, 130), (float)0.9f, (int)60, (float)0.95f), attacker.getX(), attacker.getY() + (double)(attacker.getBbHeight() / 2.0f), attacker.getZ(), 10, (double)(attacker.getBbWidth() / 2.0f), (double)(attacker.getBbHeight() / 2.0f), (double)(attacker.getBbWidth() / 2.0f), (double)0.025f);
        }
    }
}

